/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.planner;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.esql.core.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLike;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardLike;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.esql.core.planner.ExpressionTranslator;
import org.elasticsearch.xpack.esql.core.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.core.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.MultiMatchQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.NotQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.QueryStringQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.RegexQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.WildcardQuery;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;

public final class ExpressionTranslators {
    public static Query or(Source source, Query left, Query right) {
        return ExpressionTranslators.boolQuery(source, left, right, false);
    }

    private static Query and(Source source, Query left, Query right) {
        return ExpressionTranslators.boolQuery(source, left, right, true);
    }

    private static Query boolQuery(Source source, Query left, Query right, boolean isAnd) {
        BoolQuery bool;
        BoolQuery rightBool;
        BoolQuery leftBool;
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List<Query> queries = left instanceof BoolQuery && (leftBool = (BoolQuery)left).isAnd() == isAnd ? (right instanceof BoolQuery && (rightBool = (BoolQuery)right).isAnd() == isAnd ? CollectionUtils.combine(leftBool.queries(), rightBool.queries()) : CollectionUtils.combine(leftBool.queries(), right)) : (right instanceof BoolQuery && (bool = (BoolQuery)right).isAnd() == isAnd ? CollectionUtils.combine(bool.queries(), left) : Arrays.asList(left, right));
        return new BoolQuery(source, isAnd, queries);
    }

    public static class IsNulls
    extends ExpressionTranslator<IsNull> {
        @Override
        protected Query asQuery(IsNull isNull, TranslatorHandler handler) {
            return IsNulls.doTranslate(isNull, handler);
        }

        public static Query doTranslate(IsNull isNull, TranslatorHandler handler) {
            return handler.wrapFunctionQuery(isNull, isNull.field(), () -> IsNulls.translate(isNull, handler));
        }

        private static Query translate(IsNull isNull, TranslatorHandler handler) {
            return new NotQuery(isNull.source(), new ExistsQuery(isNull.source(), handler.nameOf(isNull.field())));
        }
    }

    public static class IsNotNulls
    extends ExpressionTranslator<IsNotNull> {
        @Override
        protected Query asQuery(IsNotNull isNotNull, TranslatorHandler handler) {
            return IsNotNulls.doTranslate(isNotNull, handler);
        }

        public static Query doTranslate(IsNotNull isNotNull, TranslatorHandler handler) {
            return handler.wrapFunctionQuery(isNotNull, isNotNull.field(), () -> IsNotNulls.translate(isNotNull, handler));
        }

        private static Query translate(IsNotNull isNotNull, TranslatorHandler handler) {
            return new ExistsQuery(isNotNull.source(), handler.nameOf(isNotNull.field()));
        }
    }

    public static class Nots
    extends ExpressionTranslator<Not> {
        @Override
        protected Query asQuery(Not not, TranslatorHandler handler) {
            return Nots.doTranslate(not, handler);
        }

        public static Query doTranslate(Not not, TranslatorHandler handler) {
            Query wrappedQuery = handler.asQuery(not.field());
            Query q = wrappedQuery.negate(not.source());
            return q;
        }
    }

    public static class BinaryLogic
    extends ExpressionTranslator<org.elasticsearch.xpack.esql.core.expression.predicate.logical.BinaryLogic> {
        @Override
        protected Query asQuery(org.elasticsearch.xpack.esql.core.expression.predicate.logical.BinaryLogic e, TranslatorHandler handler) {
            if (e instanceof And) {
                return ExpressionTranslators.and(e.source(), handler.asQuery(e.left()), handler.asQuery(e.right()));
            }
            if (e instanceof Or) {
                return ExpressionTranslators.or(e.source(), handler.asQuery(e.left()), handler.asQuery(e.right()));
            }
            return null;
        }
    }

    public static class MultiMatches
    extends ExpressionTranslator<MultiMatchQueryPredicate> {
        @Override
        protected Query asQuery(MultiMatchQueryPredicate q, TranslatorHandler handler) {
            return MultiMatches.doTranslate(q, handler);
        }

        public static Query doTranslate(MultiMatchQueryPredicate q, TranslatorHandler handler) {
            return new MultiMatchQuery(q.source(), q.query(), q.fields(), q);
        }
    }

    public static class StringQueries
    extends ExpressionTranslator<StringQueryPredicate> {
        @Override
        protected Query asQuery(StringQueryPredicate q, TranslatorHandler handler) {
            return StringQueries.doTranslate(q, handler);
        }

        public static Query doTranslate(StringQueryPredicate q, TranslatorHandler handler) {
            return new QueryStringQuery(q.source(), q.query(), q.fields(), q);
        }
    }

    public static class Likes
    extends ExpressionTranslator<RegexMatch> {
        @Override
        protected Query asQuery(RegexMatch e, TranslatorHandler handler) {
            return Likes.doTranslate(e, handler);
        }

        public static Query doTranslate(RegexMatch e, TranslatorHandler handler) {
            Expression field = e.field();
            if (field instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)field;
                return handler.wrapFunctionQuery(e, fa, () -> Likes.translateField(e, handler.nameOf(fa.exactAttribute())));
            }
            if (!(field instanceof MetadataAttribute)) {
                throw new QlIllegalArgumentException("Cannot translate query for " + String.valueOf(e));
            }
            MetadataAttribute ma = (MetadataAttribute)field;
            Query q = Likes.translateField(e, handler.nameOf(ma));
            return q;
        }

        private static Query translateField(RegexMatch e, String targetFieldName) {
            if (e instanceof WildcardLike) {
                WildcardLike l = (WildcardLike)e;
                return new WildcardQuery(e.source(), targetFieldName, ((WildcardPattern)l.pattern()).asLuceneWildcard(), l.caseInsensitive());
            }
            if (e instanceof RLike) {
                RLike rl = (RLike)e;
                return new RegexQuery(e.source(), targetFieldName, ((RLikePattern)rl.pattern()).asJavaRegex(), rl.caseInsensitive());
            }
            return null;
        }
    }
}

