/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.planner;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.ReflectionUtils;

public abstract class ExpressionTranslator<E extends Expression> {
    private final Class<E> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

    public Query translate(Expression exp, TranslatorHandler handler) {
        return this.typeToken.isInstance(exp) ? this.asQuery(exp, handler) : null;
    }

    protected abstract Query asQuery(E var1, TranslatorHandler var2);

    public static FieldAttribute checkIsFieldAttribute(Expression e) {
        Check.isTrue(e instanceof FieldAttribute, "Expected a FieldAttribute but received [{}]", e);
        return (FieldAttribute)e;
    }

    public static TypedAttribute checkIsPushableAttribute(Expression e) {
        Check.isTrue(e instanceof FieldAttribute || e instanceof MetadataAttribute, "Expected a FieldAttribute or MetadataAttribute but received [{}]", e);
        return (TypedAttribute)e;
    }

    public static String pushableAttributeName(TypedAttribute attribute) {
        String string;
        if (attribute instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attribute;
            string = fa.exactAttribute().name();
        } else {
            string = attribute.name();
        }
        return string;
    }
}

