/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.logical;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class Not
extends UnaryScalarFunction
implements Negatable<Expression> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Not", Not::new);

    public Not(Source source, Expression child) {
        super(source, child);
    }

    private Not(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Not.ENTRY.name;
    }

    @Override
    protected NodeInfo<Not> info() {
        return NodeInfo.create(this, Not::new, this.field());
    }

    @Override
    protected Not replaceChild(Expression newChild) {
        return new Not(this.source(), newChild);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (DataType.BOOLEAN == this.field().dataType()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isBoolean(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public Object fold() {
        return Not.apply(this.field().fold());
    }

    private static Boolean apply(Object input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof Boolean)) {
            throw new QlIllegalArgumentException("A boolean is required; received {}", input);
        }
        return (Boolean)input != false ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected Expression canonicalize() {
        if (this.field() instanceof Negatable) {
            return ((Expression)((Negatable)((Object)this.field())).negate()).canonical();
        }
        return super.canonicalize();
    }

    @Override
    public Expression negate() {
        return this.field();
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    static Expression negate(Expression exp) {
        return exp instanceof Negatable ? ((Negatable)((Object)exp)).negate() : new Not(exp.source(), exp);
    }
}

