/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.type.DataType;

public final class Expressions {
    private Expressions() {
    }

    public static NamedExpression wrapAsNamed(Expression exp) {
        NamedExpression namedExpression;
        if (exp instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)exp;
            namedExpression = ne;
        } else {
            namedExpression = new Alias(exp.source(), exp.sourceText(), exp);
        }
        return namedExpression;
    }

    public static List<Attribute> asAttributes(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(named.size());
        for (NamedExpression namedExpression : named) {
            list.add(namedExpression.toAttribute());
        }
        return list;
    }

    public static AttributeMap<Expression> asAttributeMap(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return AttributeMap.emptyAttributeMap();
        }
        AttributeMap<Expression> map = new AttributeMap<Expression>();
        for (NamedExpression namedExpression : named) {
            map.add(namedExpression.toAttribute(), namedExpression);
        }
        return map;
    }

    public static boolean anyMatch(List<? extends Expression> exps, Predicate<? super Expression> predicate) {
        for (Expression expression : exps) {
            if (!expression.anyMatch(predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(List<? extends Expression> exps, Predicate<? super Expression> predicate) {
        for (Expression expression : exps) {
            if (!predicate.test(expression)) continue;
            return true;
        }
        return false;
    }

    public static Nullability nullable(List<? extends Expression> exps) {
        Nullability value = Nullability.FALSE;
        for (Expression expression : exps) {
            switch (expression.nullable()) {
                case UNKNOWN: {
                    return Nullability.UNKNOWN;
                }
                case TRUE: {
                    value = Nullability.TRUE;
                    break;
                }
            }
        }
        return value;
    }

    public static List<Expression> canonicalize(List<? extends Expression> exps) {
        ArrayList<Expression> canonical = new ArrayList<Expression>(exps.size());
        for (Expression expression : exps) {
            canonical.add(expression.canonical());
        }
        return canonical;
    }

    public static boolean foldable(List<? extends Expression> exps) {
        for (Expression expression : exps) {
            if (expression.foldable()) continue;
            return false;
        }
        return true;
    }

    public static List<Object> fold(List<? extends Expression> exps) {
        ArrayList<Object> folded = new ArrayList<Object>(exps.size());
        for (Expression expression : exps) {
            folded.add(expression.fold());
        }
        return folded;
    }

    public static AttributeSet references(List<? extends Expression> exps) {
        if (exps.isEmpty()) {
            return AttributeSet.EMPTY;
        }
        AttributeSet set = new AttributeSet();
        for (Expression expression : exps) {
            set.addAll(expression.references());
        }
        return set;
    }

    public static String name(Expression e) {
        String string;
        if (e instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)e;
            string = ne.name();
        } else {
            string = e.sourceText();
        }
        return string;
    }

    public static boolean isNull(Expression e) {
        return e.dataType() == DataType.NULL || e.foldable() && e.fold() == null;
    }

    public static List<String> names(Collection<? extends Expression> e) {
        ArrayList<String> names = new ArrayList<String>(e.size());
        for (Expression expression : e) {
            names.add(Expressions.name(expression));
        }
        return names;
    }

    public static Attribute attribute(Expression e) {
        if (e instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)e;
            return ne.toAttribute();
        }
        return null;
    }

    public static boolean isPresent(NamedExpression e) {
        return !(e instanceof EmptyAttribute);
    }

    public static boolean equalsAsAttribute(Expression left, Expression right) {
        if (!left.semanticEquals(right)) {
            Attribute l = Expressions.attribute(left);
            return l != null && l.semanticEquals(Expressions.attribute(right));
        }
        return true;
    }

    public static List<Tuple<Attribute, Expression>> aliases(List<? extends NamedExpression> named) {
        ArrayList<Tuple<Attribute, Expression>> aliases = new ArrayList<Tuple<Attribute, Expression>>();
        for (NamedExpression namedExpression : named) {
            if (!(namedExpression instanceof Alias)) continue;
            Alias as = (Alias)namedExpression;
            aliases.add((Tuple<Attribute, Expression>)new Tuple((Object)namedExpression.toAttribute(), (Object)as.child()));
        }
        return aliases;
    }

    public static String id(Expression e) {
        return Integer.toHexString(e.hashCode());
    }
}

