/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.authn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestResponse;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.security.x509.X509Credential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SamlAuthnRequestValidator {
    private final SamlFactory samlFactory;
    private final SamlIdentityProvider idp;
    private static final Logger logger = LogManager.getLogger(SamlAuthnRequestValidator.class);
    private static final String[] XSD_FILES = new String[]{"/org/elasticsearch/xpack/idp/saml/support/saml-schema-protocol-2.0.xsd", "/org/elasticsearch/xpack/idp/saml/support/saml-schema-assertion-2.0.xsd", "/org/elasticsearch/xpack/idp/saml/support/xenc-schema.xsd", "/org/elasticsearch/xpack/idp/saml/support/xmldsig-core-schema.xsd"};
    private static final ThreadLocal<DocumentBuilder> THREAD_LOCAL_DOCUMENT_BUILDER = ThreadLocal.withInitial(() -> {
        try {
            return SamlFactory.getHardenedBuilder(XSD_FILES);
        }
        catch (Exception e) {
            throw new ElasticsearchSecurityException("Could not load XSD schema file", e, new Object[0]);
        }
    });

    public SamlAuthnRequestValidator(SamlFactory samlFactory, SamlIdentityProvider idp) {
        SamlInit.initialize();
        this.samlFactory = samlFactory;
        this.idp = idp;
    }

    public void processQueryString(String queryString, ActionListener<SamlValidateAuthnRequestResponse> listener) {
        ParsedQueryString parsedQueryString;
        try {
            parsedQueryString = this.parseQueryString(queryString);
        }
        catch (ElasticsearchSecurityException e) {
            logger.debug("Failed to parse query string for SAML AuthnRequest", (Throwable)e);
            listener.onFailure((Exception)((Object)e));
            return;
        }
        try {
            Element root = this.parseSamlMessage(SamlAuthnRequestValidator.inflate(this.decodeBase64(parsedQueryString.samlRequest)));
            if (!SamlFactory.elementNameMatches(root, "urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest")) {
                this.logAndRespond("SAML message [" + SamlFactory.text(root, 128) + "] is not an AuthnRequest", listener);
                return;
            }
            AuthnRequest authnRequest = SamlFactory.buildXmlObject(root, AuthnRequest.class);
            this.getSpFromAuthnRequest(authnRequest.getIssuer(), authnRequest.getAssertionConsumerServiceURL(), (ActionListener<SamlServiceProvider>)listener.delegateFailureAndWrap((l, sp) -> {
                try {
                    this.validateAuthnRequest(authnRequest, (SamlServiceProvider)sp, parsedQueryString, (ActionListener<SamlValidateAuthnRequestResponse>)l);
                }
                catch (ElasticsearchSecurityException e) {
                    logger.debug("Could not validate AuthnRequest", (Throwable)e);
                    l.onFailure((Exception)((Object)e));
                }
                catch (Exception e) {
                    this.logAndRespond("Could not validate AuthnRequest", e, (ActionListener<SamlValidateAuthnRequestResponse>)l);
                }
            }));
        }
        catch (ElasticsearchSecurityException e) {
            logger.debug("Could not process AuthnRequest", (Throwable)e);
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logAndRespond("Could not process AuthnRequest", e, listener);
        }
    }

    private ParsedQueryString parseQueryString(String queryString) throws ElasticsearchSecurityException {
        HashMap parameters = new HashMap();
        RestUtils.decodeQueryString((String)queryString, (int)0, parameters);
        if (parameters.isEmpty()) {
            throw new ElasticsearchSecurityException("Invalid Authentication Request query string (zero parameters)", new Object[0]);
        }
        logger.trace(() -> Strings.format((String)"Parsed the following parameters from the query string: %s", (Object[])new Object[]{parameters}));
        String samlRequest = (String)parameters.get("SAMLRequest");
        if (null == samlRequest) {
            throw new ElasticsearchSecurityException("Query string [{}] does not contain a SAMLRequest parameter", RestStatus.BAD_REQUEST, new Object[]{queryString});
        }
        return new ParsedQueryString(queryString, samlRequest, (String)parameters.get("RelayState"), (String)parameters.get("SigAlg"), (String)parameters.get("Signature"));
    }

    private void validateAuthnRequest(AuthnRequest authnRequest, SamlServiceProvider sp, ParsedQueryString parsedQueryString, ActionListener<SamlValidateAuthnRequestResponse> listener) {
        if (sp.shouldSignAuthnRequests()) {
            if (org.elasticsearch.common.Strings.hasText((String)parsedQueryString.signature)) {
                if (!org.elasticsearch.common.Strings.hasText((String)parsedQueryString.sigAlg)) {
                    this.logAndRespond(Strings.format((String)"Query string [%s] contains a Signature but SigAlg parameter is missing", (Object[])new Object[]{parsedQueryString.queryString}), listener);
                    return;
                }
                Set<X509Credential> spSigningCredentials = sp.getSpSigningCredentials();
                if (spSigningCredentials == null || spSigningCredentials.isEmpty()) {
                    this.logAndRespond(Strings.format((String)"Unable to validate signature of authentication request, Service Provider [%s] hasn't registered signing credentials", (Object[])new Object[]{sp.getEntityId()}), listener);
                    return;
                }
                if (!this.validateSignature(parsedQueryString, spSigningCredentials)) {
                    this.logAndRespond(Strings.format((String)"Unable to validate signature of authentication request [%s] using credentials [%s]", (Object[])new Object[]{parsedQueryString.queryString, SamlFactory.describeCredentials(spSigningCredentials)}), listener);
                    return;
                }
            } else {
                if (org.elasticsearch.common.Strings.hasText((String)parsedQueryString.sigAlg)) {
                    this.logAndRespond(Strings.format((String)"Query string [%s] contains a SigAlg parameter but Signature is missing", (Object[])new Object[]{parsedQueryString.queryString}), listener);
                    return;
                }
                this.logAndRespond(Strings.format((String)"The Service Provider [%s] must sign authentication requests but no signature was found", (Object[])new Object[]{sp.getEntityId()}), listener);
                return;
            }
        }
        HashMap<String, Object> authnState = new HashMap<String, Object>();
        this.checkDestination(authnRequest);
        String acs = SamlAuthnRequestValidator.checkAcs(authnRequest, sp, authnState);
        SamlAuthnRequestValidator.validateNameIdPolicy(authnRequest, sp, authnState);
        authnState.put(SamlAuthenticationState.Fields.AUTHN_REQUEST_ID.getPreferredName(), authnRequest.getID());
        SamlValidateAuthnRequestResponse response = new SamlValidateAuthnRequestResponse(sp.getEntityId(), acs, authnRequest.isForceAuthn(), authnState);
        logger.trace(() -> Strings.format((String)"Validated AuthnResponse from queryString [%s] and extracted [%s]", (Object[])new Object[]{parsedQueryString.queryString, response}));
        listener.onResponse((Object)response);
    }

    private static void validateNameIdPolicy(AuthnRequest request, SamlServiceProvider sp, Map<String, Object> authnState) {
        NameIDPolicy nameIDPolicy = request.getNameIDPolicy();
        if (null != nameIDPolicy) {
            String requestedFormat = nameIDPolicy.getFormat();
            String allowedFormat = sp.getAllowedNameIdFormat();
            if (org.elasticsearch.common.Strings.hasText((String)requestedFormat)) {
                if (allowedFormat != null && !requestedFormat.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified") && !requestedFormat.equals(allowedFormat)) {
                    throw new ElasticsearchSecurityException("The requested NameID format [{}] doesn't match the allowed NameID format for this Service Provider which is [{}]", new Object[]{requestedFormat, sp.getAllowedNameIdFormat()});
                }
                authnState.put(SamlAuthenticationState.Fields.NAMEID_FORMAT.getPreferredName(), requestedFormat);
            }
        }
    }

    private boolean validateSignature(ParsedQueryString queryString, Collection<X509Credential> credentials) {
        String javaSigAlgorithm = SamlFactory.getJavaAlorithmNameFromUri(queryString.sigAlg);
        byte[] contentBytes = queryString.reconstructQueryParameters().getBytes(StandardCharsets.UTF_8);
        byte[] signatureBytes = Base64.getDecoder().decode(queryString.signature);
        return credentials.stream().anyMatch(credential -> {
            try {
                Signature sig = Signature.getInstance(javaSigAlgorithm);
                sig.initVerify(credential.getEntityCertificate().getPublicKey());
                sig.update(contentBytes);
                return sig.verify(signatureBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ElasticsearchSecurityException("Java signature algorithm [{}] is not available for SAML/XML-Sig algorithm [{}]", (Exception)e, new Object[]{javaSigAlgorithm, queryString.sigAlg});
            }
            catch (InvalidKeyException | SignatureException e) {
                logger.warn(() -> Strings.format((String)"Signature verification failed for credential [%s]", (Object[])new Object[]{SamlFactory.describeCredentials(Set.of(credential))}), (Throwable)e);
                return false;
            }
        });
    }

    private void getSpFromAuthnRequest(Issuer issuer, String acs, ActionListener<SamlServiceProvider> listener) {
        if (issuer == null || issuer.getValue() == null) {
            throw new ElasticsearchSecurityException("SAML authentication request has no issuer", RestStatus.BAD_REQUEST, new Object[0]);
        }
        String issuerString = issuer.getValue();
        this.idp.resolveServiceProvider(issuerString, acs, false, (ActionListener<SamlServiceProvider>)listener.delegateFailureAndWrap((delegate, serviceProvider) -> {
            if (null == serviceProvider) {
                throw new ElasticsearchSecurityException("Service Provider with Entity ID [{}] and ACS [{}] is not known to this Identity Provider", RestStatus.BAD_REQUEST, new Object[]{issuerString, acs});
            }
            delegate.onResponse(serviceProvider);
        }));
    }

    private void checkDestination(AuthnRequest request) {
        String url = this.idp.getSingleSignOnEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect").toString();
        if (!url.equals(request.getDestination())) {
            throw new ElasticsearchSecurityException("SAML authentication request [{}] is for destination [{}] but the SSO endpoint of this Identity Provider is [{}]", RestStatus.BAD_REQUEST, new Object[]{request.getID(), request.getDestination(), url});
        }
    }

    private static String checkAcs(AuthnRequest request, SamlServiceProvider sp, Map<String, Object> authnState) {
        String acs = request.getAssertionConsumerServiceURL();
        if (!org.elasticsearch.common.Strings.hasText((String)acs)) {
            String message = request.getAssertionConsumerServiceIndex() == null ? "SAML authentication does not contain an AssertionConsumerService URL" : "SAML authentication does not contain an AssertionConsumerService URL. It contains an Assertion Consumer Service Index but this IDP doesn't support multiple AssertionConsumerService URLs.";
            throw new ElasticsearchSecurityException(message, RestStatus.BAD_REQUEST, new Object[0]);
        }
        if (!acs.equals(sp.getAssertionConsumerService().toString())) {
            throw new ElasticsearchSecurityException("The registered ACS URL for this Service Provider is [{}] but the authentication request contained [{}]", RestStatus.BAD_REQUEST, new Object[]{sp.getAssertionConsumerService(), acs});
        }
        return acs;
    }

    protected Element parseSamlMessage(byte[] content) {
        Element root;
        try (ByteArrayInputStream input = new ByteArrayInputStream(content);){
            Document doc = THREAD_LOCAL_DOCUMENT_BUILDER.get().parse(input);
            root = doc.getDocumentElement();
            if (logger.isTraceEnabled()) {
                logger.trace("Received SAML Message: {} \n", (Object)this.samlFactory.toString(root, true));
            }
        }
        catch (IOException | SAXException e) {
            throw new ElasticsearchSecurityException("Failed to parse SAML message", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
        return root;
    }

    private byte[] decodeBase64(String content) {
        try {
            return Base64.getDecoder().decode(content.replaceAll("\\s+", ""));
        }
        catch (IllegalArgumentException e) {
            logger.info("Failed to decode base64 string [{}] - {}", (Object)content, (Object)e);
            throw new ElasticsearchSecurityException("SAML message cannot be Base64 decoded", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] inflate(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String urlEncode(String param) {
        return URLEncoder.encode(param, StandardCharsets.UTF_8);
    }

    private void logAndRespond(String message, ActionListener<SamlValidateAuthnRequestResponse> listener) {
        logger.debug(message);
        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException(message, new Object[0])));
    }

    private void logAndRespond(String message, Throwable e, ActionListener<SamlValidateAuthnRequestResponse> listener) {
        logger.debug(message);
        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException(message, new Object[]{e})));
    }

    private class ParsedQueryString {
        private final String queryString;
        private final String samlRequest;
        @Nullable
        private final String relayState;
        @Nullable
        private final String sigAlg;
        @Nullable
        private final String signature;

        private ParsedQueryString(String queryString, String samlRequest, String relayState, String sigAlg, String signature) {
            this.queryString = Objects.requireNonNull(queryString, "Query string may not be null");
            this.samlRequest = Objects.requireNonNull(samlRequest, "SAML request parameter may not be null");
            this.relayState = relayState;
            this.sigAlg = sigAlg;
            this.signature = signature;
        }

        public String reconstructQueryParameters() throws ElasticsearchSecurityException {
            return this.relayState == null ? "SAMLRequest=" + SamlAuthnRequestValidator.urlEncode(this.samlRequest) + "&SigAlg=" + SamlAuthnRequestValidator.urlEncode(this.sigAlg) : "SAMLRequest=" + SamlAuthnRequestValidator.urlEncode(this.samlRequest) + "&RelayState=" + SamlAuthnRequestValidator.urlEncode(this.relayState) + "&SigAlg=" + SamlAuthnRequestValidator.urlEncode(this.sigAlg);
        }
    }
}

