/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public class RestExecuteWatchAction
extends BaseRestHandler
implements RestRequestFilter {
    private static final List<String> RESERVED_FIELD_NAMES = Arrays.asList(WatchField.TRIGGER.getPreferredName(), WatchField.INPUT.getPreferredName(), WatchField.CONDITION.getPreferredName(), WatchField.ACTIONS.getPreferredName(), WatchField.TRANSFORM.getPreferredName(), WatchField.THROTTLE_PERIOD.getPreferredName(), WatchField.THROTTLE_PERIOD_HUMAN.getPreferredName(), WatchField.METADATA.getPreferredName(), WatchField.STATUS.getPreferredName());
    private static final Set<String> FILTERED_FIELDS = Set.of("watch.input.http.request.auth.basic.password", "watch.input.chain.inputs.*.http.request.auth.basic.password", "watch.actions.*.email.attachments.*.reporting.auth.basic.password", "watch.actions.*.webhook.auth.basic.password");

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_watcher/watch/{id}/_execute").replaces(RestRequest.Method.POST, "/_xpack/watcher/watch/{id}/_execute", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_watcher/watch/{id}/_execute").replaces(RestRequest.Method.PUT, "/_xpack/watcher/watch/{id}/_execute", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_watcher/watch/_execute").replaces(RestRequest.Method.POST, "/_xpack/watcher/watch/_execute", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_watcher/watch/_execute").replaces(RestRequest.Method.PUT, "/_xpack/watcher/watch/_execute", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "watcher_execute_watch";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        ExecuteWatchRequest executeWatchRequest = RestExecuteWatchAction.parseRequest(request, client);
        return channel -> client.execute((ActionType)ExecuteWatchAction.INSTANCE, (ActionRequest)executeWatchRequest, (ActionListener)new RestBuilderListener<ExecuteWatchResponse>(channel){

            public RestResponse buildResponse(ExecuteWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field(Field.ID.getPreferredName(), response.getRecordId());
                builder.field(Field.WATCH_RECORD.getPreferredName(), (ToXContent)response.getRecordSource(), (ToXContent.Params)request);
                builder.endObject();
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    static ExecuteWatchRequest parseRequest(RestRequest request, NodeClient client) throws IOException {
        ExecuteWatchRequestBuilder builder = new ExecuteWatchRequestBuilder((ElasticsearchClient)client);
        builder.setId(request.param("id"));
        builder.setDebug(WatcherParams.debug((ToXContent.Params)request));
        if (!request.hasContent()) {
            return (ExecuteWatchRequest)builder.request();
        }
        builder.setRecordExecution(request.paramAsBoolean(Field.RECORD_EXECUTION.getPreferredName(), ((ExecuteWatchRequest)builder.request()).isRecordExecution()));
        builder.setIgnoreCondition(request.paramAsBoolean(Field.IGNORE_CONDITION.getPreferredName(), ((ExecuteWatchRequest)builder.request()).isIgnoreCondition()));
        try (XContentParser parser = request.contentParser();){
            XContentParser.Token token;
            parser.nextToken();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_BOOLEAN) {
                    if (Field.IGNORE_CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setIgnoreCondition(parser.booleanValue());
                        continue;
                    }
                    if (Field.RECORD_EXECUTION.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setRecordExecution(parser.booleanValue());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse watch execution request. unexpected boolean field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (Field.ALTERNATIVE_INPUT.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setAlternativeInput(parser.map());
                        continue;
                    }
                    if (Field.TRIGGER_DATA.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setTriggerData(parser.map());
                        continue;
                    }
                    if (Field.WATCH.match(currentFieldName, parser.getDeprecationHandler())) {
                        XContentBuilder watcherSource = XContentBuilder.builder((XContent)parser.contentType().xContent());
                        try {
                            watcherSource.generator().copyCurrentStructure(parser);
                            builder.setWatchSource(BytesReference.bytes((XContentBuilder)watcherSource), parser.contentType());
                            continue;
                        }
                        finally {
                            if (watcherSource != null) {
                                watcherSource.close();
                            }
                            continue;
                        }
                    }
                    if (Field.ACTION_MODES.match(currentFieldName, parser.getDeprecationHandler())) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_STRING) {
                                try {
                                    ActionExecutionMode mode = ActionExecutionMode.resolve((String)parser.textOrNull());
                                    builder.setActionMode(currentFieldName, mode);
                                    continue;
                                }
                                catch (IllegalArgumentException iae) {
                                    throw new ElasticsearchParseException("could not parse watch execution request", (Throwable)iae, new Object[0]);
                                }
                            }
                            throw new ElasticsearchParseException("could not parse watch execution request. unexpected array field [{}]", new Object[]{currentFieldName});
                        }
                        continue;
                    }
                    if (RESERVED_FIELD_NAMES.contains(currentFieldName)) {
                        throw new ElasticsearchParseException("please wrap watch including field [{}] inside a \"watch\" field", new Object[]{currentFieldName});
                    }
                    throw new ElasticsearchParseException("could not parse watch execution request. unexpected object field [{}]", new Object[]{currentFieldName});
                }
                throw new ElasticsearchParseException("could not parse watch execution request. unexpected token [{}]", new Object[]{token});
            }
        }
        return (ExecuteWatchRequest)builder.request();
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static interface Field {
        public static final ParseField ID = new ParseField("_id", new String[0]);
        public static final ParseField WATCH_RECORD = new ParseField("watch_record", new String[0]);
        public static final ParseField RECORD_EXECUTION = new ParseField("record_execution", new String[0]);
        public static final ParseField ACTION_MODES = new ParseField("action_modes", new String[0]);
        public static final ParseField ALTERNATIVE_INPUT = new ParseField("alternative_input", new String[0]);
        public static final ParseField IGNORE_CONDITION = new ParseField("ignore_condition", new String[0]);
        public static final ParseField TRIGGER_DATA = new ParseField("trigger_data", new String[0]);
        public static final ParseField WATCH = new ParseField("watch", new String[0]);
    }
}

