/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;

public final class GroupByOptimizer {
    private GroupByOptimizer() {
    }

    static Collection<Map.Entry<String, SingleGroupSource>> reorderGroups(Map<String, SingleGroupSource> groups, Set<String> runtimeFields) {
        if (groups.size() == 1) {
            return groups.entrySet();
        }
        ArrayList<Tuple> prioritizedGroups = new ArrayList<Tuple>(groups.size());
        int basePriority = groups.size();
        for (Map.Entry<String, SingleGroupSource> groupBy : groups.entrySet()) {
            int priority = basePriority-- + (groupBy.getValue().getScriptConfig() == null ? (runtimeFields.contains(groupBy.getValue().getField()) ? 250 : 500) : 0);
            switch (groupBy.getValue().getType()) {
                case DATE_HISTOGRAM: {
                    priority += 4000;
                    break;
                }
                case HISTOGRAM: {
                    priority += 3000;
                    break;
                }
                case TERMS: {
                    priority += 2000;
                    break;
                }
                case GEOTILE_GRID: {
                    priority += 1000;
                    break;
                }
                default: {
                    assert (false) : "new group source type misses priority definition";
                    break;
                }
            }
            prioritizedGroups.add(new Tuple(groupBy, (Object)priority));
        }
        prioritizedGroups.sort(Comparator.comparing(Tuple::v2).reversed());
        return prioritizedGroups.stream().map(x -> (Map.Entry)x.v1()).collect(Collectors.toList());
    }
}

