/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.latest;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.latest.LatestConfig;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.IDGenerator;
import org.elasticsearch.xpack.transform.transforms.common.AbstractCompositeAggFunction;
import org.elasticsearch.xpack.transform.transforms.common.DocumentConversionUtils;
import org.elasticsearch.xpack.transform.transforms.latest.LatestChangeCollector;

public class Latest
extends AbstractCompositeAggFunction {
    public static final int DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE = 5000;
    private static final String TOP_HITS_AGGREGATION_NAME = "_top_hits";
    private final LatestConfig config;

    public Latest(LatestConfig config) {
        super(Latest.createCompositeAggregation(config));
        this.config = config;
    }

    private static CompositeAggregationBuilder createCompositeAggregation(LatestConfig config) {
        List sources = config.getUniqueKey().stream().map(field -> (TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(field).field(field)).missingBucket(true)).collect(Collectors.toList());
        TopHitsAggregationBuilder topHitsAgg = AggregationBuilders.topHits((String)TOP_HITS_AGGREGATION_NAME).size(1).sorts(config.getSorts());
        return (CompositeAggregationBuilder)AggregationBuilders.composite((String)"_transform", sources).subAggregation((AggregationBuilder)topHitsAgg);
    }

    @Override
    public int getInitialPageSize() {
        return 5000;
    }

    @Override
    public Function.ChangeCollector buildChangeCollector(String synchronizationField) {
        return new LatestChangeCollector(synchronizationField);
    }

    private static Map<String, Object> convertBucketToDocument(CompositeAggregation.Bucket bucket, LatestConfig config, TransformIndexerStats transformIndexerStats, TransformProgress progress) {
        transformIndexerStats.incrementNumDocuments(bucket.getDocCount());
        progress.incrementDocsProcessed(bucket.getDocCount());
        progress.incrementDocsIndexed(1L);
        TopHits topHits = (TopHits)bucket.getAggregations().get(TOP_HITS_AGGREGATION_NAME);
        if (topHits.getHits().getHits().length != 1) {
            throw new ElasticsearchException("Unexpected number of hits in the top_hits aggregation result. Wanted: 1, was: {}", new Object[]{topHits.getHits().getHits().length});
        }
        Map document = topHits.getHits().getHits()[0].getSourceAsMap();
        IDGenerator idGen = new IDGenerator();
        config.getUniqueKey().forEach(field -> idGen.add((String)field, bucket.getKey().get(field)));
        document.put(TransformField.DOCUMENT_ID_FIELD, idGen.getID());
        return document;
    }

    @Override
    public void validateConfig(ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    @Override
    public List<String> getPerformanceCriticalFields() {
        return this.config.getUniqueKey();
    }

    @Override
    public void deduceMappings(Client client, Map<String, String> headers, String transformId, SourceConfig sourceConfig, ActionListener<Map<String, String>> listener) {
        listener.onResponse(Collections.emptyMap());
    }

    @Override
    public SearchSourceBuilder buildSearchQueryForInitialProgress(SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder existsClauses = QueryBuilders.boolQuery();
        this.config.getUniqueKey().forEach(field -> existsClauses.must((QueryBuilder)QueryBuilders.existsQuery((String)field)));
        return searchSourceBuilder.query((QueryBuilder)existsClauses).size(0).trackTotalHits(true);
    }

    @Override
    protected Stream<Map<String, Object>> extractResults(CompositeAggregation agg, Map<String, String> fieldTypeMap, TransformIndexerStats transformIndexerStats, TransformProgress transformProgress) {
        return agg.getBuckets().stream().map(bucket -> Latest.convertBucketToDocument(bucket, this.config, transformIndexerStats, transformProgress));
    }

    @Override
    protected Map<String, Object> documentTransformationFunction(Map<String, Object> document) {
        return DocumentConversionUtils.removeInternalFields(document);
    }
}

