/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.rest.action;

import java.time.Instant;
import java.util.List;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestStartTransformAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_transform/{id}/_start"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String id = restRequest.param(TransformField.ID.getPreferredName());
        String fromAsString = restRequest.param(TransformField.FROM.getPreferredName());
        Instant from = fromAsString != null ? RestStartTransformAction.parseDateOrThrow(fromAsString, TransformField.FROM, System::currentTimeMillis) : null;
        TimeValue timeout = restRequest.paramAsTime(TransformField.TIMEOUT.getPreferredName(), AcknowledgedRequest.DEFAULT_ACK_TIMEOUT);
        StartTransformAction.Request request = new StartTransformAction.Request(id, from, timeout);
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)StartTransformAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    private static Instant parseDateOrThrow(String date, ParseField paramName, LongSupplier now) {
        DateMathParser dateMathParser = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.toDateMathParser();
        try {
            return dateMathParser.parse(date, now);
        }
        catch (Exception e) {
            String msg = TransformMessages.getMessage((String)"Failed to parse date for [{0}]", (Object[])new Object[]{paramName.getPreferredName(), date});
            throw new ElasticsearchParseException(msg, (Throwable)e, new Object[0]);
        }
    }

    public String getName() {
        return "transform_start_transform_action";
    }
}

