/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefArrayBlock;
import org.elasticsearch.compute.data.BytesRefArrayVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ConstantBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class BytesRefBlockBuilder
extends AbstractBlockBuilder
implements BytesRefBlock.Builder {
    private BytesRefArray values;

    BytesRefBlockBuilder(int estimatedSize, BigArrays bigArrays, BlockFactory blockFactory) {
        super(blockFactory);
        this.values = new BytesRefArray((long)Math.max(estimatedSize, 2), bigArrays);
    }

    @Override
    public BytesRefBlockBuilder appendBytesRef(BytesRef value) {
        this.ensureCapacity();
        this.values.append(value);
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return -1;
    }

    @Override
    protected int valuesLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void growValuesArray(int newSize) {
        throw new AssertionError((Object)"should not reach here");
    }

    @Override
    public BytesRefBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public BytesRefBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public BytesRefBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    protected void writeNullValue() {
        this.values.append(BytesRefBlock.NULL_VALUE);
    }

    @Override
    public BytesRefBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((BytesRefBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public BytesRefBlockBuilder copyFrom(BytesRefBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        BytesRefVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(BytesRefBlock block, int beginInclusive, int endExclusive) {
        BytesRef scratch = new BytesRef();
        for (int p = beginInclusive; p < endExclusive; ++p) {
            if (block.isNull(p)) {
                this.appendNull();
                continue;
            }
            int count = block.getValueCount(p);
            if (count > 1) {
                this.beginPositionEntry();
            }
            int i = block.getFirstValueIndex(p);
            for (int v = 0; v < count; ++v) {
                this.appendBytesRef(block.getBytesRef(i++, scratch));
            }
            if (count <= 1) continue;
            this.endPositionEntry();
        }
    }

    private void copyFromVector(BytesRefVector vector, int beginInclusive, int endExclusive) {
        BytesRef scratch = new BytesRef();
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendBytesRef(vector.getBytesRef(p, scratch));
        }
    }

    @Override
    public BytesRefBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    @Override
    public long estimatedBytes() {
        return super.estimatedBytes() + BytesRefArrayBlock.BASE_RAM_BYTES_USED + this.values.ramBytesUsed();
    }

    private BytesRefBlock buildFromBytesArray() {
        BytesRefBlock theBlock;
        assert (this.estimatedBytes == 0L || this.firstValueIndexes != null);
        if (this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1) {
            theBlock = new ConstantBytesRefVector(BytesRef.deepCopyOf((BytesRef)this.values.get(0L, new BytesRef())), 1, this.blockFactory).asBlock();
            this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes);
            Releasables.closeExpectNoException((Releasable)this.values);
        } else {
            theBlock = this.isDense() && this.singleValued() ? new BytesRefArrayVector(this.values, this.positionCount, this.blockFactory).asBlock() : new BytesRefArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.blockFactory);
            this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes - this.values.bigArraysRamBytesUsed());
        }
        return theBlock;
    }

    @Override
    public BytesRefBlock build() {
        try {
            this.finish();
            BytesRefBlock theBlock = this.buildFromBytesArray();
            this.values = null;
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void extraClose() {
        Releasables.closeExpectNoException((Releasable)this.values);
    }
}

