/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;

abstract class CentroidPointAggregator {
    CentroidPointAggregator() {
    }

    public static void combine(CentroidState current, double xVal, double xDel, double yVal, double yDel, long count) {
        current.add(xVal, xDel, yVal, yDel, count);
    }

    public static void combineStates(CentroidState current, CentroidState state) {
        current.add(state);
    }

    public static void combineIntermediate(CentroidState state, double xIn, double dx, double yIn, double dy, long count) {
        if (count > 0L) {
            CentroidPointAggregator.combine(state, xIn, dx, yIn, dy, count);
        }
    }

    public static void evaluateIntermediate(CentroidState state, DriverContext driverContext, Block[] blocks, int offset) {
        assert (blocks.length >= offset + 5);
        BlockFactory blockFactory = driverContext.blockFactory();
        blocks[offset + 0] = blockFactory.newConstantDoubleBlockWith(state.xSum.value(), 1);
        blocks[offset + 1] = blockFactory.newConstantDoubleBlockWith(state.xSum.delta(), 1);
        blocks[offset + 2] = blockFactory.newConstantDoubleBlockWith(state.ySum.value(), 1);
        blocks[offset + 3] = blockFactory.newConstantDoubleBlockWith(state.ySum.delta(), 1);
        blocks[offset + 4] = blockFactory.newConstantLongBlockWith(state.count, 1);
    }

    public static Block evaluateFinal(CentroidState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static void combineStates(GroupingCentroidState current, int groupId, GroupingCentroidState state, int statePosition) {
        if (state.hasValue(statePosition)) {
            current.add(state.xValues.get((long)statePosition), state.xDeltas.get((long)statePosition), state.yValues.get((long)statePosition), state.yDeltas.get((long)statePosition), state.counts.get((long)statePosition), groupId);
        }
    }

    public static void combineIntermediate(GroupingCentroidState current, int groupId, double xValue, double xDelta, double yValue, double yDelta, long count) {
        if (count > 0L) {
            current.add(xValue, xDelta, yValue, yDelta, count, groupId);
        }
    }

    public static void evaluateIntermediate(GroupingCentroidState state, Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 5);
        try (DoubleBlock.Builder xValuesBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
             DoubleBlock.Builder xDeltaBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
             DoubleBlock.Builder yValuesBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
             DoubleBlock.Builder yDeltaBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
             LongBlock.Builder countsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < state.xValues.size()) {
                    xValuesBuilder.appendDouble(state.xValues.get((long)group));
                    xDeltaBuilder.appendDouble(state.xDeltas.get((long)group));
                    yValuesBuilder.appendDouble(state.yValues.get((long)group));
                    yDeltaBuilder.appendDouble(state.yDeltas.get((long)group));
                    countsBuilder.appendLong(state.counts.get((long)group));
                    continue;
                }
                xValuesBuilder.appendDouble(0.0);
                xDeltaBuilder.appendDouble(0.0);
                yValuesBuilder.appendDouble(0.0);
                yDeltaBuilder.appendDouble(0.0);
                countsBuilder.appendLong(0L);
            }
            blocks[offset + 0] = xValuesBuilder.build();
            blocks[offset + 1] = xDeltaBuilder.build();
            blocks[offset + 2] = yValuesBuilder.build();
            blocks[offset + 3] = yDeltaBuilder.build();
            blocks[offset + 4] = countsBuilder.build();
        }
    }

    public static Block evaluateFinal(GroupingCentroidState state, IntVector selected, DriverContext driverContext) {
        try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int si = selected.getInt(i);
                if (state.hasValue(si) && (long)si < state.xValues.size()) {
                    BytesRef result = state.encodeCentroidResult(si);
                    builder.appendBytesRef(result);
                    continue;
                }
                builder.appendNull();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private static BytesRef encode(double x, double y) {
        return new BytesRef(WellKnownBinary.toWKB((Geometry)new Point(x, y), (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    static class CentroidState
    implements AggregatorState {
        protected final CompensatedSum xSum = new CompensatedSum(0.0, 0.0);
        protected final CompensatedSum ySum = new CompensatedSum(0.0, 0.0);
        protected long count = 0L;

        CentroidState() {
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            CentroidPointAggregator.evaluateIntermediate(this, driverContext, blocks, offset);
        }

        public void close() {
        }

        public void count(long count) {
            this.count = count;
        }

        public void add(CentroidState other) {
            this.xSum.add(other.xSum.value(), other.xSum.delta());
            this.ySum.add(other.ySum.value(), other.ySum.delta());
            this.count += other.count;
        }

        public void add(double x, double y) {
            this.xSum.add(x);
            this.ySum.add(y);
            ++this.count;
        }

        public void add(double x, double dx, double y, double dy, long count) {
            this.xSum.add(x, dx);
            this.ySum.add(y, dy);
            this.count += count;
        }

        protected Block toBlock(BlockFactory blockFactory) {
            if (this.count > 0L) {
                double x = this.xSum.value() / (double)this.count;
                double y = this.ySum.value() / (double)this.count;
                return blockFactory.newConstantBytesRefBlockWith(CentroidPointAggregator.encode(x, y), 1);
            }
            return blockFactory.newConstantNullBlock(1);
        }
    }

    static class GroupingCentroidState
    implements GroupingAggregatorState {
        private final BigArrays bigArrays;
        DoubleArray xValues;
        DoubleArray xDeltas;
        DoubleArray yValues;
        DoubleArray yDeltas;
        LongArray counts;

        GroupingCentroidState(BigArrays bigArrays) {
            this.bigArrays = bigArrays;
            boolean success = false;
            try {
                this.xValues = bigArrays.newDoubleArray(1L);
                this.xDeltas = bigArrays.newDoubleArray(1L);
                this.yValues = bigArrays.newDoubleArray(1L);
                this.yDeltas = bigArrays.newDoubleArray(1L);
                this.counts = bigArrays.newLongArray(1L);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        void add(double x, double dx, double y, double dy, long count, int groupId) {
            this.ensureCapacity(groupId);
            if (!Double.isFinite(x) || !Double.isFinite(y)) {
                this.xValues.increment((long)groupId, x);
                this.yValues.increment((long)groupId, y);
                return;
            }
            GroupingCentroidState.addTo(this.xValues, this.xDeltas, groupId, x, dx);
            GroupingCentroidState.addTo(this.yValues, this.yDeltas, groupId, y, dy);
            this.counts.increment((long)groupId, count);
        }

        private static void addTo(DoubleArray values, DoubleArray deltas, int groupId, double valueToAdd, double deltaToAdd) {
            double value = values.get((long)groupId);
            if (!Double.isFinite(value)) {
                return;
            }
            double delta = deltas.get((long)groupId);
            double correctedSum = valueToAdd + (delta + deltaToAdd);
            double updatedValue = value + correctedSum;
            deltas.set((long)groupId, correctedSum - (updatedValue - value));
            values.set((long)groupId, updatedValue);
        }

        boolean hasValue(int index) {
            return this.counts.get((long)index) > 0L;
        }

        final void enableGroupIdTracking(SeenGroupIds ignore) {
        }

        private void ensureCapacity(int groupId) {
            if ((long)groupId >= this.xValues.size()) {
                this.xValues = this.bigArrays.grow(this.xValues, (long)(groupId + 1));
                this.xDeltas = this.bigArrays.grow(this.xDeltas, (long)(groupId + 1));
                this.yValues = this.bigArrays.grow(this.yValues, (long)(groupId + 1));
                this.yDeltas = this.bigArrays.grow(this.yDeltas, (long)(groupId + 1));
                this.counts = this.bigArrays.grow(this.counts, (long)(groupId + 1));
            }
        }

        protected BytesRef encodeCentroidResult(int si) {
            long count = this.counts.get((long)si);
            double x = this.xValues.get((long)si) / (double)count;
            double y = this.yValues.get((long)si) / (double)count;
            return CentroidPointAggregator.encode(x, y);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            CentroidPointAggregator.evaluateIntermediate(this, blocks, offset, selected, driverContext);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.xValues, this.xDeltas, this.yValues, this.yDeltas, this.counts});
        }
    }
}

