/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopIntAggregatorFunctionSupplier(List<Integer> channels, int limit, boolean ascending) {
        this.channels = channels;
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public TopIntAggregatorFunction aggregator(DriverContext driverContext) {
        return TopIntAggregatorFunction.create(driverContext, this.channels, this.limit, this.ascending);
    }

    @Override
    public TopIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return TopIntGroupingAggregatorFunction.create(this.channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of ints";
    }
}

