/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileDoubleAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileDoubleGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileDoubleAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final List<Integer> channels;
    private final double percentile;

    public PercentileDoubleAggregatorFunctionSupplier(List<Integer> channels, double percentile) {
        this.channels = channels;
        this.percentile = percentile;
    }

    @Override
    public PercentileDoubleAggregatorFunction aggregator(DriverContext driverContext) {
        return PercentileDoubleAggregatorFunction.create(driverContext, this.channels, this.percentile);
    }

    @Override
    public PercentileDoubleGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return PercentileDoubleGroupingAggregatorFunction.create(this.channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of doubles";
    }
}

