/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BytesRefArrayState
implements GroupingAggregatorState,
Releasable {
    private final BigArrays bigArrays;
    private final CircuitBreaker breaker;
    private final String breakerLabel;
    private ObjectArray<BreakingBytesRefBuilder> values;
    private boolean groupIdTrackingEnabled;

    BytesRefArrayState(BigArrays bigArrays, CircuitBreaker breaker, String breakerLabel) {
        this.bigArrays = bigArrays;
        this.breaker = breaker;
        this.breakerLabel = breakerLabel;
        this.values = bigArrays.newObjectArray(0L);
    }

    BytesRef get(int groupId) {
        return ((BreakingBytesRefBuilder)this.values.get((long)groupId)).bytesRefView();
    }

    void set(int groupId, BytesRef value) {
        this.ensureCapacity(groupId);
        BreakingBytesRefBuilder currentBuilder = (BreakingBytesRefBuilder)this.values.get((long)groupId);
        if (currentBuilder == null) {
            currentBuilder = new BreakingBytesRefBuilder(this.breaker, this.breakerLabel, value.length);
            this.values.set((long)groupId, (Object)currentBuilder);
        }
        currentBuilder.copyBytes(value);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        if (!this.groupIdTrackingEnabled) {
            try (BytesRefVector.Builder builder = driverContext.blockFactory().newBytesRefVectorBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int group = selected.getInt(i);
                    BytesRef value = this.get(group);
                    builder.appendBytesRef(value);
                }
                BytesRefBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    BytesRef value = this.get(group);
                    builder.appendBytesRef(value);
                    continue;
                }
                builder.appendNull();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        int minSize = groupId + 1;
        if ((long)minSize > this.values.size()) {
            long prevSize = this.values.size();
            this.values = this.bigArrays.grow(this.values, (long)minSize);
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 2);
        try (BytesRefVector.Builder valuesBuilder = driverContext.blockFactory().newBytesRefVectorBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasValueBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            BytesRef emptyBytesRef = new BytesRef();
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    BytesRef value = this.get(group);
                    valuesBuilder.appendBytesRef(value);
                } else {
                    valuesBuilder.appendBytesRef(emptyBytesRef);
                }
                hasValueBuilder.appendBoolean(i, this.hasValue(group));
            }
            blocks[offset] = valuesBuilder.build().asBlock();
            blocks[offset + 1] = hasValueBuilder.build().asBlock();
        }
    }

    boolean hasValue(int groupId) {
        return (long)groupId < this.values.size() && this.values.get((long)groupId) != null;
    }

    void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        this.groupIdTrackingEnabled = true;
    }

    public void close() {
        int i = 0;
        while ((long)i < this.values.size()) {
            Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{(Releasable)this.values.get((long)i)});
            ++i;
        }
        Releasables.close(this.values);
    }
}

