/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.xpack.rank.rrf.RRFRankDoc;
import org.elasticsearch.xpack.rank.rrf.RRFRankShardResult;

public class RRFQueryPhaseRankShardContext
extends QueryPhaseRankShardContext {
    private final int rankConstant;

    public RRFQueryPhaseRankShardContext(List<Query> queries, int rankWindowSize, int rankConstant) {
        super(queries, rankWindowSize);
        this.rankConstant = rankConstant;
    }

    public RRFRankShardResult combineQueryPhaseResults(List<TopDocs> rankResults) {
        int rank;
        int queries = rankResults.size();
        Map docsToRankResults = Maps.newMapWithExpectedSize((int)this.rankWindowSize);
        int index = 0;
        for (TopDocs rrfRankResult : rankResults) {
            rank = 1;
            for (ScoreDoc scoreDoc : rrfRankResult.scoreDocs) {
                int findex = index;
                int frank = rank++;
                docsToRankResults.compute(scoreDoc.doc, (key, value) -> {
                    if (value == null) {
                        value = new RRFRankDoc(scoreDoc.doc, scoreDoc.shardIndex, queries, this.rankConstant);
                    }
                    value.score += 1.0f / (float)(this.rankConstant + frank);
                    value.positions[findex] = frank - 1;
                    value.scores[findex] = scoreDoc.score;
                    return value;
                });
            }
            ++index;
        }
        RRFRankDoc[] sortedResults = (RRFRankDoc[])docsToRankResults.values().toArray(RRFRankDoc[]::new);
        Arrays.sort(sortedResults, (rrf1, rrf2) -> {
            if (rrf1.score != rrf2.score) {
                return rrf1.score < rrf2.score ? 1 : -1;
            }
            assert (rrf1.positions.length == rrf2.positions.length);
            for (int qi = 0; qi < rrf1.positions.length; ++qi) {
                if (rrf1.positions[qi] != -1 && rrf2.positions[qi] != -1) {
                    if (rrf1.scores[qi] == rrf2.scores[qi]) continue;
                    return rrf1.scores[qi] < rrf2.scores[qi] ? 1 : -1;
                }
                if (rrf1.positions[qi] != -1) {
                    return -1;
                }
                if (rrf2.positions[qi] == -1) continue;
                return 1;
            }
            return rrf1.doc < rrf2.doc ? -1 : 1;
        });
        RRFRankDoc[] topResults = new RRFRankDoc[Math.min(this.rankWindowSize, sortedResults.length)];
        for (rank = 0; rank < topResults.length; ++rank) {
            topResults[rank] = sortedResults[rank];
            topResults[rank].rank = rank + 1;
            topResults[rank].score = Float.NaN;
        }
        return new RRFRankShardResult(rankResults.size(), topResults);
    }

    public int rankConstant() {
        return this.rankConstant;
    }
}

