/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.rest.action.role.NativeRoleBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetRolesAction
extends NativeRoleBaseRestHandler {
    public RestGetRolesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/role/").replaces(RestRequest.Method.GET, "/_xpack/security/role/", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/role/{name}").replaces(RestRequest.Method.GET, "/_xpack/security/role/{name}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_get_roles_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] roles = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        boolean restrictToNativeRolesOnly = request.isServerlessRequest() && false == request.isOperatorRequest();
        return channel -> new GetRolesRequestBuilder((ElasticsearchClient)client).names(roles).nativeOnly(restrictToNativeRolesOnly).execute((ActionListener)new RestBuilderListener<GetRolesResponse>(channel){

            public RestResponse buildResponse(GetRolesResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (RoleDescriptor role : response.roles()) {
                    builder.field(role.getName(), (ToXContent)role);
                }
                builder.endObject();
                if (roles.length != 0 && response.roles().length == 0) {
                    return new RestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        if (!request.isServerlessRequest() || request.isOperatorRequest()) {
            return null;
        }
        return super.innerCheckFeatureAvailable(request);
    }
}

