/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.operator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

public class FileOperatorUsersStore {
    private static final Logger logger = LogManager.getLogger(FileOperatorUsersStore.class);
    private final Path file;
    private volatile OperatorUsersDescriptor operatorUsersDescriptor;
    private static final OperatorUsersDescriptor EMPTY_OPERATOR_USERS_DESCRIPTOR = new OperatorUsersDescriptor(List.of());
    private static final ConstructingObjectParser<Group, Void> GROUP_PARSER = new ConstructingObjectParser("operator_privileges.operator.group", false, arr -> new Group(Set.copyOf((List)arr[0]), (String)arr[1], (String)arr[2], (String)arr[3], (String)arr[4], arr[5] == null ? null : Set.copyOf((List)arr[5])));
    private static final ConstructingObjectParser<OperatorUsersDescriptor, Void> OPERATOR_USER_PARSER = new ConstructingObjectParser("operator_privileges.operator", false, arr -> new OperatorUsersDescriptor((List)arr[0]));

    public FileOperatorUsersStore(Environment env, ResourceWatcherService watcherService) {
        this.file = XPackPlugin.resolveConfigFile((Environment)env, (String)"operator_users.yml");
        this.operatorUsersDescriptor = FileOperatorUsersStore.parseFile(this.file, logger);
        FileWatcher watcher = new FileWatcher(this.file.getParent(), true);
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to start watching the operator users file [" + String.valueOf(this.file.toAbsolutePath()) + "]", (Throwable)e, new Object[0]);
        }
    }

    public boolean isOperatorUser(Authentication authentication) {
        Authentication.RealmRef realm = authentication.getEffectiveSubject().getRealm();
        if (realm == null) {
            return false;
        }
        return this.operatorUsersDescriptor.groups.stream().anyMatch(group -> {
            boolean match = !(!group.usernames.contains(authentication.getEffectiveSubject().getUser().principal()) || group.authenticationType != authentication.getAuthenticationType() || !realm.getType().equals(group.realmType) || group.realmName != null && !group.realmName.equals(realm.getName()) || group.tokenSource != null && !group.tokenSource.equalsIgnoreCase((String)authentication.getEffectiveSubject().getMetadata().get("_token_source")) || group.tokenNames != null && !group.tokenNames.contains(authentication.getEffectiveSubject().getMetadata().get("_token_name")));
            logger.trace("Matching user [{}] against operator rule [{}] is [{}]", (Object)authentication.getEffectiveSubject().getUser(), group, (Object)match);
            return match;
        });
    }

    public OperatorUsersDescriptor getOperatorUsersDescriptor() {
        return this.operatorUsersDescriptor;
    }

    public static OperatorUsersDescriptor parseFile(Path file, Logger logger) {
        OperatorUsersDescriptor operatorUsersDescriptor;
        block9: {
            if (!Files.exists(file, new LinkOption[0])) {
                logger.warn("Operator privileges [{}] is enabled, but operator user file does not exist. No user will be able to perform operator-only actions.", (Object)OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.getKey());
                return EMPTY_OPERATOR_USERS_DESCRIPTOR;
            }
            logger.debug("Reading operator users file [{}]", (Object)file.toAbsolutePath());
            InputStream in = Files.newInputStream(file, StandardOpenOption.READ);
            try {
                OperatorUsersDescriptor operatorUsersDescriptor2 = FileOperatorUsersStore.parseConfig(in);
                logger.info("parsed [{}] group(s) with a total of [{}] operator user(s) from file [{}]", (Object)operatorUsersDescriptor2.groups.size(), (Object)operatorUsersDescriptor2.groups.stream().mapToLong(g -> g.usernames.size()).sum(), (Object)file.toAbsolutePath());
                logger.debug("operator user descriptor: [{}]", (Object)operatorUsersDescriptor2);
                operatorUsersDescriptor = operatorUsersDescriptor2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    logger.error(() -> "Failed to parse operator users file [" + String.valueOf(file) + "].", (Throwable)e);
                    throw new ElasticsearchParseException("Error parsing operator users file [{}]", (Throwable)e, new Object[]{file.toAbsolutePath()});
                }
            }
            in.close();
        }
        return operatorUsersDescriptor;
    }

    static OperatorUsersDescriptor parseConfig(InputStream in) throws IOException {
        try (XContentParser parser = FileOperatorUsersStore.yamlParser(in);){
            OperatorUsersDescriptor operatorUsersDescriptor = (OperatorUsersDescriptor)OPERATOR_USER_PARSER.parse(parser, null);
            return operatorUsersDescriptor;
        }
    }

    private static XContentParser yamlParser(InputStream in) throws IOException {
        return XContentType.YAML.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, in);
    }

    static {
        GROUP_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), Fields.USERNAMES);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.REALM_NAME);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.REALM_TYPE);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.AUTH_TYPE);
        GROUP_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Fields.TOKEN_SOURCE);
        GROUP_PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), Fields.TOKEN_NAMES);
        OPERATOR_USER_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ignore) -> (Group)GROUP_PARSER.parse(parser, null), Fields.OPERATOR);
    }

    static final class OperatorUsersDescriptor {
        private final List<Group> groups;

        private OperatorUsersDescriptor(List<Group> groups) {
            this.groups = groups;
        }

        List<Group> getGroups() {
            return this.groups;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorUsersDescriptor that = (OperatorUsersDescriptor)o;
            return this.groups.equals(that.groups);
        }

        public int hashCode() {
            return Objects.hash(this.groups);
        }

        public String toString() {
            return "OperatorUsersDescriptor{groups=" + String.valueOf(this.groups) + "}";
        }
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            OperatorUsersDescriptor newDescriptor;
            if (file.equals(FileOperatorUsersStore.this.file) && !FileOperatorUsersStore.this.operatorUsersDescriptor.equals(newDescriptor = FileOperatorUsersStore.parseFile(file, logger))) {
                logger.info("operator users file [{}] changed. updating operator users...", (Object)file.toAbsolutePath());
                FileOperatorUsersStore.this.operatorUsersDescriptor = newDescriptor;
            }
        }
    }

    static final class Group {
        private static final Set<String> SINGLETON_REALM_TYPES = Set.of("file", "native", "reserved", "_service_account");
        private final Set<String> usernames;
        private final String realmName;
        private final String realmType;
        private final String tokenSource;
        private final Set<String> tokenNames;
        private final Authentication.AuthenticationType authenticationType;

        Group(Set<String> usernames) {
            this(usernames, null);
        }

        Group(Set<String> usernames, @Nullable String realmName) {
            this(usernames, realmName, null, null, null, null);
        }

        Group(Set<String> usernames, @Nullable String realmName, @Nullable String realmType, @Nullable String authenticationType, @Nullable String tokenSource, @Nullable Set<String> tokenNames) {
            this.usernames = usernames;
            this.realmName = realmName;
            this.realmType = realmType == null ? "file" : realmType;
            this.authenticationType = authenticationType == null ? Authentication.AuthenticationType.REALM : Authentication.AuthenticationType.valueOf((String)authenticationType.toUpperCase(Locale.ROOT));
            this.tokenSource = tokenSource;
            this.tokenNames = tokenNames;
            this.validate();
        }

        private void validate() {
            ValidationException validationException = new ValidationException();
            if (this.realmName == null && !SINGLETON_REALM_TYPES.contains(this.realmType)) {
                validationException.addValidationError("[realm_name] must be specified for realm types other than [" + Strings.collectionToCommaDelimitedString(new TreeSet<String>(SINGLETON_REALM_TYPES)) + "]");
            }
            if (this.authenticationType == Authentication.AuthenticationType.REALM) {
                if (!"file".equals(this.realmType) && !"jwt".equals(this.realmType)) {
                    validationException.addValidationError("when [auth_type] is defined as [realm] then [realm_type] must be defined as [file] or [jwt]");
                }
                if (this.tokenNames != null) {
                    validationException.addValidationError("[token_names] is not valid when [realm_type] is [file]");
                }
                if (this.tokenSource != null) {
                    validationException.addValidationError("[token_source] is not valid when [realm_type] is [file]");
                }
            } else if (this.authenticationType == Authentication.AuthenticationType.TOKEN) {
                if (!"_service_account".equals(this.realmType)) {
                    validationException.addValidationError("[realm_type] requires [_service_account] when [auth_type] is [token]");
                }
                if (this.usernames.size() > 1 && "_service_account".equals(this.realmType)) {
                    validationException.addValidationError("[usernames] must be a single value when auth_type is [token] and realm_type is [_service_account]");
                }
                if (this.tokenSource == null) {
                    validationException.addValidationError("[token_source] must be set when [auth_type] is [token]");
                } else if (!Arrays.stream(TokenInfo.TokenSource.values()).anyMatch(v -> v.name().equalsIgnoreCase(this.tokenSource))) {
                    validationException.addValidationError("[token_source] must be one of the following values [" + Arrays.stream(TokenInfo.TokenSource.values()).map(v -> v.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(",")) + "]");
                }
                if (this.tokenNames == null) {
                    validationException.addValidationError("[token_names] must be set when [auth_type] is [token]");
                }
            } else {
                validationException.addValidationError("[auth_type] only supports [realm] or [token]");
            }
            if (!validationException.validationErrors().isEmpty()) {
                throw validationException;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Group[");
            sb.append("usernames=").append(this.usernames);
            if (this.realmName != null) {
                sb.append(", realm_name=").append(this.realmName);
            }
            if (this.realmType != null) {
                sb.append(", realm_type=").append(this.realmType);
            }
            if (this.authenticationType != null) {
                sb.append(", auth_type=").append(this.authenticationType.name().toLowerCase(Locale.ROOT));
            }
            if (this.tokenSource != null) {
                sb.append(", token_source=").append(this.tokenSource);
            }
            if (this.tokenNames != null) {
                sb.append(", token_names=").append(this.tokenNames);
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return Objects.equals(this.usernames, group.usernames) && Objects.equals(this.realmName, group.realmName) && Objects.equals(this.realmType, group.realmType) && Objects.equals(this.tokenSource, group.tokenSource) && Objects.equals(this.tokenNames, group.tokenNames) && this.authenticationType == group.authenticationType;
        }

        public int hashCode() {
            return Objects.hash(this.usernames, this.realmName, this.realmType, this.tokenSource, this.tokenNames, this.authenticationType);
        }
    }

    public static interface Fields {
        public static final ParseField OPERATOR = new ParseField("operator", new String[0]);
        public static final ParseField USERNAMES = new ParseField("usernames", new String[0]);
        public static final ParseField REALM_NAME = new ParseField("realm_name", new String[0]);
        public static final ParseField REALM_TYPE = new ParseField("realm_type", new String[0]);
        public static final ParseField AUTH_TYPE = new ParseField("auth_type", new String[0]);
        public static final ParseField TOKEN_SOURCE = new ParseField("token_source", new String[0]);
        public static final ParseField TOKEN_NAMES = new ParseField("token_names", new String[0]);
    }
}

