/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.stats;

import java.util.Map;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.esql.stats.PlanningMetrics;

public class PlanningMetricsManager {
    private final LongCounter featuresCounter;
    private final LongCounter featuresCounterAll;
    private final LongCounter functionsCounter;
    private final LongCounter functionsCounterAll;
    public static String ESQL_PREFIX = "es.esql.";
    public static String FEATURES_PREFIX = "commands.";
    public static String FUNCTIONS_PREFIX = "functions.";
    public static final String FEATURE_METRICS_ALL = ESQL_PREFIX + FEATURES_PREFIX + "usages.total";
    public static final String FEATURE_METRICS = ESQL_PREFIX + FEATURES_PREFIX + "queries.total";
    public static final String FUNCTION_METRICS_ALL = ESQL_PREFIX + FUNCTIONS_PREFIX + "usages.total";
    public static final String FUNCTION_METRICS = ESQL_PREFIX + FUNCTIONS_PREFIX + "queries.total";
    public static final String FEATURE_NAME = "feature_name";
    public static final String SUCCESS = "success";

    public PlanningMetricsManager(MeterRegistry meterRegistry) {
        this.featuresCounter = meterRegistry.registerLongCounter(FEATURE_METRICS, "ESQL features, total number of queries that use them", "unit");
        this.featuresCounterAll = meterRegistry.registerLongCounter(FEATURE_METRICS_ALL, "ESQL features, total usage", "unit");
        this.functionsCounter = meterRegistry.registerLongCounter(FUNCTION_METRICS, "ESQL functions, total number of queries that use them", "unit");
        this.functionsCounterAll = meterRegistry.registerLongCounter(FUNCTION_METRICS_ALL, "ESQL functions, total usage", "unit");
    }

    public void publish(PlanningMetrics metrics, boolean success) {
        metrics.commands().entrySet().forEach(x -> this.incCommand((String)x.getKey(), (Integer)x.getValue(), success));
        metrics.functions().entrySet().forEach(x -> this.incFunction((String)x.getKey(), (Integer)x.getValue(), success));
    }

    private void incCommand(String name, int count, boolean success) {
        this.featuresCounter.incrementBy(1L, Map.ofEntries(Map.entry(FEATURE_NAME, name), Map.entry(SUCCESS, success)));
        this.featuresCounterAll.incrementBy((long)count, Map.ofEntries(Map.entry(FEATURE_NAME, name), Map.entry(SUCCESS, success)));
    }

    private void incFunction(String name, int count, boolean success) {
        this.functionsCounter.incrementBy(1L, Map.ofEntries(Map.entry(FEATURE_NAME, name), Map.entry(SUCCESS, success)));
        this.functionsCounterAll.incrementBy((long)count, Map.ofEntries(Map.entry(FEATURE_NAME, name), Map.entry(SUCCESS, success)));
    }
}

