/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class FragmentExec
extends LeafExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "FragmentExec", FragmentExec::new);
    private final LogicalPlan fragment;
    private final QueryBuilder esFilter;
    private final PhysicalPlan reducer;
    private final int estimatedRowSize;

    public FragmentExec(LogicalPlan fragment) {
        this(fragment.source(), fragment, null, 0, null);
    }

    public FragmentExec(Source source, LogicalPlan fragment, QueryBuilder esFilter, int estimatedRowSize, PhysicalPlan reducer) {
        super(source);
        this.fragment = fragment;
        this.esFilter = esFilter;
        this.estimatedRowSize = estimatedRowSize;
        this.reducer = reducer;
    }

    private FragmentExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), in.readOptionalVInt(), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? (PhysicalPlan)in.readOptionalNamedWriteable(PhysicalPlan.class) : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.fragment());
        out.writeOptionalNamedWriteable((NamedWriteable)this.esFilter());
        out.writeOptionalVInt(this.estimatedRowSize());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.reducer);
        }
    }

    public String getWriteableName() {
        return FragmentExec.ENTRY.name;
    }

    public LogicalPlan fragment() {
        return this.fragment;
    }

    public QueryBuilder esFilter() {
        return this.esFilter;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    public PhysicalPlan reducer() {
        return this.reducer;
    }

    protected NodeInfo<FragmentExec> info() {
        return NodeInfo.create((Node)this, FragmentExec::new, (Object)((Object)this.fragment), (Object)this.esFilter, (Object)this.estimatedRowSize, (Object)((Object)this.reducer));
    }

    @Override
    public List<Attribute> output() {
        return this.fragment.output();
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int estimatedRowSize = state.consumeAllFields(false);
        return Objects.equals(estimatedRowSize, this.estimatedRowSize) ? this : new FragmentExec(this.source(), this.fragment, this.esFilter, estimatedRowSize, this.reducer);
    }

    public FragmentExec withFragment(LogicalPlan fragment) {
        return Objects.equals((Object)fragment, (Object)this.fragment) ? this : new FragmentExec(this.source(), fragment, this.esFilter, this.estimatedRowSize, this.reducer);
    }

    public FragmentExec withFilter(QueryBuilder filter) {
        return Objects.equals(filter, this.esFilter) ? this : new FragmentExec(this.source(), this.fragment, filter, this.estimatedRowSize, this.reducer);
    }

    public FragmentExec withReducer(PhysicalPlan reducer) {
        return Objects.equals((Object)reducer, (Object)this.reducer) ? this : new FragmentExec(this.source(), this.fragment, this.esFilter, this.estimatedRowSize, reducer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fragment, this.esFilter, this.estimatedRowSize, this.reducer});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FragmentExec other = (FragmentExec)obj;
        return Objects.equals((Object)this.fragment, (Object)other.fragment) && Objects.equals(this.esFilter, other.esFilter) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize) && Objects.equals((Object)this.reducer, (Object)other.reducer);
    }

    public String nodeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeName());
        sb.append("[filter=");
        sb.append(this.esFilter);
        sb.append(", estimatedRowSize=");
        sb.append(this.estimatedRowSize);
        sb.append(", reducer=[");
        sb.append(this.reducer == null ? "" : this.reducer.toString());
        sb.append("], fragment=[<>\n");
        sb.append(this.fragment.toString());
        sb.append("<>]]");
        return sb.toString();
    }
}

