/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class FieldExtractExec
extends UnaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "FieldExtractExec", FieldExtractExec::new);
    private final List<Attribute> attributesToExtract;
    private final Attribute sourceAttribute;
    private final Set<Attribute> docValuesAttributes;
    private List<Attribute> lazyOutput;

    public FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract) {
        this(source, child, attributesToExtract, Set.of());
    }

    private FieldExtractExec(Source source, PhysicalPlan child, List<Attribute> attributesToExtract, Set<Attribute> docValuesAttributes) {
        super(source, child);
        this.attributesToExtract = attributesToExtract;
        this.sourceAttribute = FieldExtractExec.extractSourceAttributesFrom(child);
        this.docValuesAttributes = docValuesAttributes;
    }

    private FieldExtractExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteableCollection(this.attributesToExtract());
    }

    public String getWriteableName() {
        return FieldExtractExec.ENTRY.name;
    }

    public static Attribute extractSourceAttributesFrom(PhysicalPlan plan) {
        for (Attribute attribute : plan.outputSet()) {
            if (!EsQueryExec.isSourceAttribute(attribute)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    protected AttributeSet computeReferences() {
        AttributeSet required = new AttributeSet(this.docValuesAttributes);
        required.add(this.sourceAttribute);
        required.addAll(this.attributesToExtract);
        return required;
    }

    protected NodeInfo<FieldExtractExec> info() {
        return NodeInfo.create((Node)this, FieldExtractExec::new, (Object)((Object)this.child()), this.attributesToExtract);
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new FieldExtractExec(this.source(), newChild, this.attributesToExtract, this.docValuesAttributes);
    }

    public FieldExtractExec withDocValuesAttributes(Set<Attribute> docValuesAttributes) {
        return new FieldExtractExec(this.source(), this.child(), this.attributesToExtract, docValuesAttributes);
    }

    public List<Attribute> attributesToExtract() {
        return this.attributesToExtract;
    }

    public Attribute sourceAttribute() {
        return this.sourceAttribute;
    }

    public Set<Attribute> docValuesAttributes() {
        return this.docValuesAttributes;
    }

    public boolean hasDocValuesAttribute(Attribute attr) {
        return this.docValuesAttributes.contains(attr);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            List<Attribute> childOutput = this.child().output();
            this.lazyOutput = new ArrayList<Attribute>(childOutput.size() + this.attributesToExtract.size());
            this.lazyOutput.addAll(childOutput);
            this.lazyOutput.addAll(this.attributesToExtract);
        }
        return this.lazyOutput;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(true, this.attributesToExtract);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.attributesToExtract, this.docValuesAttributes, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldExtractExec other = (FieldExtractExec)obj;
        return Objects.equals(this.attributesToExtract, other.attributesToExtract) && Objects.equals(this.docValuesAttributes, other.docValuesAttributes) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    public String nodeString() {
        return this.nodeName() + NodeUtils.limitedToString(this.attributesToExtract) + "<" + NodeUtils.limitedToString(this.docValuesAttributes) + ">";
    }
}

