/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public abstract class BinaryExec
extends PhysicalPlan {
    private final PhysicalPlan left;
    private final PhysicalPlan right;

    protected BinaryExec(Source source, PhysicalPlan left, PhysicalPlan right) {
        super(source, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    public final BinaryExec replaceChildren(List<PhysicalPlan> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    protected abstract BinaryExec replaceChildren(PhysicalPlan var1, PhysicalPlan var2);

    public PhysicalPlan left() {
        return this.left;
    }

    public PhysicalPlan right() {
        return this.right;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left);
        out.writeNamedWriteable((NamedWriteable)this.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BinaryExec other = (BinaryExec)((Object)obj);
        return Objects.equals((Object)this.left, (Object)other.left) && Objects.equals((Object)this.right, (Object)other.right);
    }
}

