/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public class LookupJoin
extends Join
implements SurrogateLogicalPlan {
    private final List<Attribute> output;

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, List<Attribute> joinFields) {
        this(source, left, right, new JoinTypes.UsingJoinType(JoinTypes.LEFT, joinFields), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> joinFields, List<Attribute> leftFields, List<Attribute> rightFields, List<Attribute> output) {
        this(source, left, right, new JoinConfig(type, joinFields, leftFields, rightFields), output);
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig joinConfig, List<Attribute> output) {
        super(source, left, right, joinConfig);
        this.output = output;
    }

    @Override
    public LogicalPlan surrogate() {
        JoinConfig cfg = this.config();
        JoinConfig newConfig = new JoinConfig(JoinTypes.LEFT, cfg.matchFields(), cfg.leftFields(), cfg.rightFields());
        Join normalized = new Join(this.source(), this.left(), this.right(), newConfig);
        return new Project(this.source(), normalized, this.output);
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new LookupJoin(this.source(), left, right, this.config(), this.output);
    }

    @Override
    protected NodeInfo<Join> info() {
        return NodeInfo.create((Node)this, LookupJoin::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.config().type(), this.config().matchFields(), this.config().leftFields(), this.config().rightFields(), this.output);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.output);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LookupJoin other = (LookupJoin)obj;
        return Objects.equals(this.output, other.output);
    }
}

