/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan;

import java.util.Objects;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class TableIdentifier {
    private final Source source;
    private final String cluster;
    private final String index;

    public TableIdentifier(Source source, String catalog, String index) {
        this.source = source;
        this.cluster = catalog;
        this.index = index;
    }

    public String cluster() {
        return this.cluster;
    }

    public String index() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableIdentifier other = (TableIdentifier)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.cluster, other.cluster);
    }

    public Source source() {
        return this.source;
    }

    public String qualifiedIndex() {
        return this.cluster != null ? this.cluster + ":" + this.index : this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.cluster != null) {
            builder.append(this.cluster);
            builder.append(':');
        }
        builder.append(this.index);
        return builder.toString();
    }
}

