/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class ReplaceSourceAttributes
extends PhysicalOptimizerRules.OptimizerRule<EsSourceExec> {
    public ReplaceSourceAttributes() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected PhysicalPlan rule(EsSourceExec plan) {
        FieldAttribute docId = new FieldAttribute(plan.source(), EsQueryExec.DOC_ID_FIELD.getName(), EsQueryExec.DOC_ID_FIELD);
        if (plan.indexMode() == IndexMode.TIME_SERIES) {
            Attribute tsid = null;
            Attribute timestamp = null;
            for (Attribute attr : plan.output()) {
                String name = attr.name();
                if (name.equals("_tsid")) {
                    tsid = attr;
                    continue;
                }
                if (!name.equals("@timestamp")) continue;
                timestamp = attr;
            }
            if (tsid == null || timestamp == null) {
                throw new IllegalStateException("_tsid or @timestamp are missing from the time-series source");
            }
            return new EsQueryExec(plan.source(), plan.index(), plan.indexMode(), List.of(docId, tsid, timestamp), plan.query());
        }
        return new EsQueryExec(plan.source(), plan.index(), plan.indexMode(), List.of(docId), plan.query());
    }
}

