/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public final class AddDefaultTopN
extends OptimizerRules.ParameterizedOptimizerRule<LogicalPlan, LogicalOptimizerContext> {
    public AddDefaultTopN() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected LogicalPlan rule(LogicalPlan plan, LogicalOptimizerContext context) {
        OrderBy order;
        UnaryPlan unary;
        LogicalPlan logicalPlan;
        if (plan instanceof UnaryPlan && (logicalPlan = (unary = (UnaryPlan)plan).child()) instanceof OrderBy && (logicalPlan = (order = (OrderBy)logicalPlan).child()) instanceof EsRelation) {
            EsRelation relation = (EsRelation)logicalPlan;
            Literal limit = new Literal(plan.source(), (Object)context.configuration().resultTruncationMaxSize(), DataType.INTEGER);
            return unary.replaceChild(new TopN(plan.source(), relation, order.order(), (Expression)limit));
        }
        return plan;
    }
}

