/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.HashSet;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.plan.QueryPlan;

public class PlanConsistencyChecker<P extends QueryPlan<P>> {
    public void checkPlan(P p, Failures failures) {
        AttributeSet input;
        AttributeSet refs = ((QueryPlan)((Object)p)).references();
        AttributeSet missing = refs.subtract(input = ((QueryPlan)((Object)p)).inputSet());
        if (!missing.isEmpty()) {
            failures.add(Failure.fail(p, "Plan [{}] optimized incorrectly due to missing references {}", new Object[]{p.nodeString(), missing}));
        }
        HashSet<String> outputAttributeNames = new HashSet<String>();
        HashSet<NameId> outputAttributeIds = new HashSet<NameId>();
        for (Attribute outputAttr : ((QueryPlan)((Object)p)).output()) {
            if (outputAttributeNames.add(outputAttr.name()) && outputAttributeIds.add(outputAttr.id())) continue;
            failures.add(Failure.fail(p, "Plan [{}] optimized incorrectly due to duplicate output attribute {}", new Object[]{p.nodeString(), outputAttr.toString()}));
        }
    }
}

