/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.optimizer.rules.PlanConsistencyChecker;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public final class PhysicalVerifier {
    public static final PhysicalVerifier INSTANCE = new PhysicalVerifier();
    private static final PlanConsistencyChecker<PhysicalPlan> DEPENDENCY_CHECK = new PlanConsistencyChecker();

    private PhysicalVerifier() {
    }

    public Collection<Failure> verify(PhysicalPlan plan) {
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        plan.forEachDown(p -> {
            FieldExtractExec fieldExtractExec;
            Attribute sourceAttribute;
            if (p instanceof FieldExtractExec && (sourceAttribute = (fieldExtractExec = (FieldExtractExec)p).sourceAttribute()) == null) {
                failures.add(Failure.fail(fieldExtractExec, "Need to add field extractor for [{}] but cannot detect source attributes from node [{}]", new Object[]{Expressions.names(fieldExtractExec.attributesToExtract()), fieldExtractExec.child()}));
            }
        });
        return failures;
    }
}

