/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.ExceptionUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;

public abstract class DateTimeArithmeticOperation
extends EsqlArithmeticOperation {
    private final DatetimeArithmeticEvaluator datetimes;

    DateTimeArithmeticOperation(Source source, Expression left, Expression right, EsqlArithmeticOperation.OperationSymbol op, EsqlArithmeticOperation.BinaryEvaluator ints, EsqlArithmeticOperation.BinaryEvaluator longs, EsqlArithmeticOperation.BinaryEvaluator ulongs, EsqlArithmeticOperation.BinaryEvaluator doubles, DatetimeArithmeticEvaluator datetimes) {
        super(source, left, right, op, ints, longs, ulongs, doubles);
        this.datetimes = datetimes;
    }

    DateTimeArithmeticOperation(StreamInput in, EsqlArithmeticOperation.OperationSymbol op, EsqlArithmeticOperation.BinaryEvaluator ints, EsqlArithmeticOperation.BinaryEvaluator longs, EsqlArithmeticOperation.BinaryEvaluator ulongs, EsqlArithmeticOperation.BinaryEvaluator doubles, DatetimeArithmeticEvaluator datetimes) throws IOException {
        super(in, op, ints, longs, ulongs, doubles);
        this.datetimes = datetimes;
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isType((Expression)e, t -> t.isNumeric() || DataType.isDateTimeOrTemporal((DataType)t) || DataType.isNull((DataType)t), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal, (String[])new String[]{"datetime", "numeric"});
    }

    @Override
    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (DataType.isDateTimeOrTemporal((DataType)leftType) || DataType.isDateTimeOrTemporal((DataType)rightType)) {
            if (DataType.isNull((DataType)leftType) || DataType.isNull((DataType)rightType)) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            if (DataType.isDateTime((DataType)leftType) && DataType.isTemporalAmount((DataType)rightType) || DataType.isTemporalAmount((DataType)leftType) && DataType.isDateTime((DataType)rightType)) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            if (DataType.isTemporalAmount((DataType)leftType) && DataType.isTemporalAmount((DataType)rightType) && leftType == rightType) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            return new Expression.TypeResolution(DateTimeArithmeticOperation.formatIncompatibleTypesMessage(this.symbol(), leftType, rightType));
        }
        return super.checkCompatibility();
    }

    abstract Period fold(Period var1, Period var2);

    abstract Duration fold(Duration var1, Duration var2);

    @Override
    public final Object fold() {
        DataType leftDataType = this.left().dataType();
        DataType rightDataType = this.right().dataType();
        if (leftDataType == DataType.DATE_PERIOD && rightDataType == DataType.DATE_PERIOD) {
            Object l = this.left().fold();
            Object r = this.right().fold();
            if (l instanceof Collection || r instanceof Collection) {
                return null;
            }
            try {
                return this.fold((Period)l, (Period)r);
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (leftDataType == DataType.TIME_DURATION && rightDataType == DataType.TIME_DURATION) {
            Duration l = (Duration)this.left().fold();
            Duration r = (Duration)this.right().fold();
            try {
                return this.fold(l, r);
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (DataType.isNull((DataType)leftDataType) || DataType.isNull((DataType)rightDataType)) {
            return null;
        }
        return super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.dataType() == DataType.DATETIME) {
            Expression temporalAmountArgument;
            Expression datetimeArgument;
            if (this.left().dataType() == DataType.DATETIME) {
                datetimeArgument = this.left();
                temporalAmountArgument = this.right();
            } else {
                datetimeArgument = this.right();
                temporalAmountArgument = this.left();
            }
            return this.datetimes.apply(this.source(), toEvaluator.apply(datetimeArgument), (TemporalAmount)temporalAmountArgument.fold());
        }
        return super.toEvaluator(toEvaluator);
    }

    static interface DatetimeArithmeticEvaluator {
        public EvalOperator.ExpressionEvaluator.Factory apply(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, TemporalAmount var3);
    }
}

