/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.util;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.util.Delay;

public final class DelayEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final long ms;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DelayEvaluator(Source source, long ms, DriverContext driverContext) {
        this.source = source;
        this.ms = ms;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        return this.eval(page.getPositionCount()).asBlock();
    }

    public BooleanVector eval(int positionCount) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(p, Delay.process(this.ms));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "DelayEvaluator[ms=" + this.ms + "]";
    }

    public void close() {
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final long ms;

        public Factory(Source source, long ms) {
            this.source = source;
            this.ms = ms;
        }

        public DelayEvaluator get(DriverContext context) {
            return new DelayEvaluator(this.source, this.ms, context);
        }

        public String toString() {
            return "DelayEvaluator[ms=" + this.ms + "]";
        }
    }
}

