/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SpaceEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Space
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Space", Space::new);
    private static final long MAX_LENGTH = ByteSizeUnit.MB.toBytes(1L);

    @FunctionInfo(returnType={"keyword"}, description="Returns a string made of `number` spaces.", examples={@Example(file="string", tag="space")})
    public Space(Source source, @Param(name="number", type={"integer"}, description="Number of spaces in result.") Expression number) {
        super(source, number);
    }

    private Space(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
    }

    public String getWriteableName() {
        return Space.ENTRY.name;
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"integer"});
    }

    static BytesRef process(BreakingBytesRefBuilder scratch, int number) {
        Space.checkNumber(number);
        scratch.grow(number);
        scratch.setLength(number);
        Arrays.fill(scratch.bytes(), 0, number, (byte)32);
        return scratch.bytesRefView();
    }

    static void checkNumber(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Number parameter cannot be negative, found [" + number + "]");
        }
        if ((long)number > MAX_LENGTH) {
            throw new IllegalArgumentException("Creating strings longer than [" + MAX_LENGTH + "] bytes is not supported");
        }
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Space(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Space::new, (Object)this.field);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        Object folded;
        if (this.field.foldable() && (folded = this.field.fold()) instanceof Integer) {
            Integer num = (Integer)folded;
            Space.checkNumber(num);
            return toEvaluator.apply((Expression)new Literal(this.source(), (Object)" ".repeat(num), DataType.KEYWORD));
        }
        EvalOperator.ExpressionEvaluator.Factory numberExpr = toEvaluator.apply(this.field);
        return new SpaceEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "space"), numberExpr);
    }
}

