/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWithEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class EndsWith
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "EndsWith", EndsWith::new);
    private final Expression str;
    private final Expression suffix;

    @FunctionInfo(returnType={"boolean"}, description="Returns a boolean that indicates whether a keyword string ends with another string.", examples={@Example(file="string", tag="endsWith")})
    public EndsWith(Source source, @Param(name="str", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression str, @Param(name="suffix", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression suffix) {
        super(source, Arrays.asList(str, suffix));
        this.str = str;
        this.suffix = suffix;
    }

    private EndsWith(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.str);
        out.writeNamedWriteable((NamedWriteable)this.suffix);
    }

    public String getWriteableName() {
        return EndsWith.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.suffix, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.str.foldable() && this.suffix.foldable();
    }

    static boolean process(BytesRef str, BytesRef suffix) {
        if (str.length < suffix.length) {
            return false;
        }
        return Arrays.equals(str.bytes, str.offset + str.length - suffix.length, str.offset + str.length, suffix.bytes, suffix.offset, suffix.offset + suffix.length);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new EndsWith(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, EndsWith::new, (Object)this.str, (Object)this.suffix);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new EndsWithEvaluator.Factory(this.source(), toEvaluator.apply(this.str), toEvaluator.apply(this.suffix));
    }

    Expression str() {
        return this.str;
    }

    Expression suffix() {
        return this.suffix;
    }
}

