/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBoolean;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeBytesRef;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeDouble;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeInt;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeLong;
import org.elasticsearch.xpack.esql.capabilities.Validatable;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.Validations;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvSort
extends EsqlScalarFunction
implements OptionalArgument,
Validatable {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvSort", MvSort::new);
    private final Expression field;
    private final Expression order;
    private static final Literal ASC = new Literal(Source.EMPTY, (Object)"ASC", DataType.KEYWORD);
    private static final Literal DESC = new Literal(Source.EMPTY, (Object)"DESC", DataType.KEYWORD);
    private static final String INVALID_ORDER_ERROR = "Invalid order value in [{}], expected one of [{}, {}] but got [{}]";

    @FunctionInfo(returnType={"boolean", "date", "date_nanos", "double", "integer", "ip", "keyword", "long", "version"}, description="Sorts a multivalued field in lexicographical order.", examples={@Example(file="ints", tag="mv_sort")})
    public MvSort(Source source, @Param(name="field", type={"boolean", "date", "date_nanos", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="Multivalue expression. If `null`, the function returns `null`.") Expression field, @Param(name="order", type={"keyword"}, description="Sort order. The valid options are ASC and DESC, the default is ASC.", optional=true) Expression order) {
        super(source, order == null ? Arrays.asList(field) : Arrays.asList(field, order));
        this.field = field;
        this.order = order;
    }

    private MvSort(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeOptionalNamedWriteable((NamedWriteable)this.order);
    }

    public String getWriteableName() {
        return MvSort.ENTRY.name;
    }

    Expression field() {
        return this.field;
    }

    Expression order() {
        return this.order;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field, DataType::isRepresentable, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"representable"});
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.order == null) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.order, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.field.foldable() && (this.order == null || this.order.foldable());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        boolean ordering = true;
        if (!this.isValidOrder()) {
            throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)INVALID_ORDER_ERROR, (Object[])new Object[]{this.sourceText(), ASC.value(), DESC.value(), ((BytesRef)this.order.fold()).utf8ToString()}));
        }
        if (this.order != null && this.order.foldable()) {
            ordering = ((BytesRef)this.order.fold()).utf8ToString().equalsIgnoreCase((String)ASC.value());
        }
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.BOOLEAN -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeBoolean((BooleanBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.BOOLEAN);
            case ElementType.BYTES_REF -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeBytesRef((BytesRefBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.BYTES_REF);
            case ElementType.INT -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeInt((IntBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.INT);
            case ElementType.LONG -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeLong((LongBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.LONG);
            case ElementType.DOUBLE -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeDouble((DoubleBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.DOUBLE);
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw new IllegalArgumentException("unsupported type [" + String.valueOf(this.field.dataType()) + "]");
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvSort(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvSort::new, (Object)this.field, (Object)this.order);
    }

    public DataType dataType() {
        return this.field.dataType().noText();
    }

    @Override
    public void validate(Failures failures) {
        if (this.order == null) {
            return;
        }
        String operation = this.sourceText();
        failures.add(Validations.isFoldable(this.order, operation, TypeResolutions.ParamOrdinal.SECOND));
        if (!this.isValidOrder()) {
            failures.add(Failure.fail(this.order, INVALID_ORDER_ERROR, new Object[]{this.sourceText(), ASC.value(), DESC.value(), ((BytesRef)this.order.fold()).utf8ToString()}));
        }
    }

    private boolean isValidOrder() {
        boolean isValidOrder = true;
        if (this.order != null && this.order.foldable()) {
            Object obj = this.order.fold();
            String o = null;
            if (obj instanceof BytesRef) {
                BytesRef ob = (BytesRef)obj;
                o = ob.utf8ToString();
            } else if (obj instanceof String) {
                String os;
                o = os = (String)obj;
            }
            if (o == null || !o.equalsIgnoreCase((String)ASC.value()) && !o.equalsIgnoreCase((String)DESC.value())) {
                isValidOrder = false;
            }
        }
        return isValidOrder;
    }

    private record EvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field, boolean order, TriFunction<BlockFactory, Block, Boolean, Block> sort, ElementType dataType) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new Evaluator(context.blockFactory(), this.field.get(context), this.order, this.sort, this.dataType);
        }

        @Override
        public String toString() {
            return "MvSort" + this.dataType.pascalCaseName() + "[field=" + String.valueOf(this.field) + ", order=" + this.order + "]";
        }
    }

    private static class Evaluator
    implements EvalOperator.ExpressionEvaluator {
        private final BlockFactory blockFactory;
        private final EvalOperator.ExpressionEvaluator field;
        private final boolean order;
        private final TriFunction<BlockFactory, Block, Boolean, Block> sort;
        private final ElementType dataType;

        protected Evaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator field, boolean order, TriFunction<BlockFactory, Block, Boolean, Block> sort, ElementType dataType) {
            this.blockFactory = blockFactory;
            this.field = field;
            this.order = order;
            this.sort = sort;
            this.dataType = dataType;
        }

        public Block eval(Page page) {
            try (Block fieldBlock = this.field.eval(page);){
                Block block = (Block)this.sort.apply((Object)this.blockFactory, (Object)fieldBlock, (Object)this.order);
                return block;
            }
        }

        public String toString() {
            return "MvSort" + this.dataType.pascalCaseName() + "[field=" + String.valueOf(this.field) + ", order=" + this.order + "]";
        }

        public void close() {
        }
    }
}

