/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.DoubleConstantFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Tau
extends DoubleConstantFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Tau", Tau::new);
    public static final double TAU = Math.PI * 2;

    @FunctionInfo(returnType={"double"}, description="Returns the https://tauday.com/tau-manifesto[ratio] of a circle's circumference to its radius.", examples={@Example(file="math", tag="tau")})
    public Tau(Source source) {
        super(source);
    }

    private Tau(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
    }

    public String getWriteableName() {
        return Tau.ENTRY.name;
    }

    public Object fold() {
        return Math.PI * 2;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Tau(this.source());
    }
}

