/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanosFromDatetimeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanosFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanosFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanosFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToDateNanos
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToDateNanos", ToDateNanos::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.DATETIME, ToDateNanosFromDatetimeEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, (field, source) -> field), Map.entry(DataType.LONG, ToDateNanosFromLongEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToDateNanosFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToDateNanosFromStringEvaluator.Factory::new), Map.entry(DataType.SEMANTIC_TEXT, ToDateNanosFromStringEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToDateNanosFromDoubleEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator.Factory::new));

    @FunctionInfo(returnType={"date_nanos"}, description="Converts an input to a nanosecond-resolution date value (aka date_nanos).", note="The range for date nanos is 1970-01-01T00:00:00.000000000Z to 2262-04-11T23:47:16.854775807Z.  Additionally, integers cannot be converted into date nanos, as the range of integer nanoseconds only covers about 2 seconds after epoch.", preview=true)
    public ToDateNanos(Source source, @Param(name="field", type={"date", "date_nanos", "keyword", "text", "double", "long", "unsigned_long"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    protected ToDateNanos(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public DataType dataType() {
        return DataType.DATE_NANOS;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDateNanos(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDateNanos::new, (Object)this.field());
    }

    public String getWriteableName() {
        return ToDateNanos.ENTRY.name;
    }

    static long fromLong(long in) {
        if (in < 0L) {
            throw new IllegalArgumentException("Nanosecond dates before 1970-01-01T00:00:00.000Z are not supported.");
        }
        return in;
    }

    static long fromDouble(double in) {
        if (in < 0.0) {
            throw new IllegalArgumentException("Nanosecond dates before 1970-01-01T00:00:00.000Z are not supported.");
        }
        return DataTypeConverter.safeDoubleToLong((double)in);
    }

    static long fromKeyword(BytesRef in) {
        Instant parsed = DateFormatters.from((TemporalAccessor)EsqlDataTypeConverter.DEFAULT_DATE_NANOS_FORMATTER.parse(in.utf8ToString())).toInstant();
        return DateUtils.toLong((Instant)parsed);
    }

    static long fromDatetime(long in) {
        return DateUtils.toNanoSeconds((long)in);
    }
}

