/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;

public class Avg
extends AggregateFunction
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Avg", Avg::new);

    @FunctionInfo(returnType={"double"}, description="The average of a numeric field.", isAggregation=true, examples={@Example(file="stats", tag="avg"), @Example(description="The expression can use inline functions. For example, to calculate the average over a multivalued column, first use `MV_AVG` to average the multiple values per row, and use the result with the `AVG` function", file="stats", tag="docsStatsAvgNestedExpression")})
    public Avg(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public Avg(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long or counter types"});
    }

    private Avg(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Avg.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    protected NodeInfo<Avg> info() {
        return NodeInfo.create((Node)this, Avg::new, (Object)this.field(), (Object)this.filter());
    }

    public Avg replaceChildren(List<Expression> newChildren) {
        return new Avg(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public Avg withFilter(Expression filter) {
        return new Avg(this.source(), this.field(), filter);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        return this.field().foldable() ? new MvAvg(s, field) : new Div(s, (Expression)new Sum(s, field, this.filter()), (Expression)new Count(s, field, this.filter()), this.dataType());
    }
}

