/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.type.EsField;

public record ResolvedEnrichPolicy(String matchField, String matchType, List<String> enrichFields, Map<String, String> concreteIndices, Map<String, EsField> mapping) implements Writeable
{
    public ResolvedEnrichPolicy(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readStringCollectionAsList(), in.readMap(StreamInput::readString), in.readMap(ResolvedEnrichPolicy.getEsFieldReader(in)));
    }

    private static Writeable.Reader<EsField> getEsFieldReader(StreamInput in) {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ES_FIELD_CACHED_SERIALIZATION) || in.getTransportVersion().isPatchFrom(TransportVersions.V_8_15_2)) {
            return EsField::readFrom;
        }
        return EsField::new;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.matchField);
        out.writeString(this.matchType);
        out.writeStringCollection(this.enrichFields);
        out.writeMap(this.concreteIndices, StreamOutput::writeString);
        out.writeMap(this.mapping, (o, v) -> {
            EsField field = new EsField(v.getName(), v.getDataType(), v.getProperties(), v.isAggregatable(), v.isAlias());
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ES_FIELD_CACHED_SERIALIZATION) || out.getTransportVersion().isPatchFrom(TransportVersions.V_8_15_2)) {
                field.writeTo(o);
            } else {
                field.writeContent(o);
            }
        });
    }
}

