/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class LookupFromIndexService
extends AbstractLookupService<Request, TransportRequest> {
    public static final String LOOKUP_ACTION_NAME = "indices:data/read/esql/lookup_from_index";

    public LookupFromIndexService(ClusterService clusterService, SearchService searchService, TransportService transportService, BigArrays bigArrays, BlockFactory blockFactory) {
        super(LOOKUP_ACTION_NAME, ClusterPrivilegeResolver.MONITOR_ENRICH.name(), clusterService, searchService, transportService, bigArrays, blockFactory, TransportRequest::readFrom);
    }

    @Override
    protected TransportRequest transportRequest(Request request, ShardId shardId) {
        return new TransportRequest(request.sessionId, shardId, request.inputDataType, request.inputPage, null, request.extractFields, request.matchField, request.source);
    }

    @Override
    protected QueryList queryList(TransportRequest request, SearchExecutionContext context, Block inputBlock, DataType inputDataType) {
        MappedFieldType fieldType = context.getFieldType(request.matchField);
        return LookupFromIndexService.termQueryList(fieldType, context, inputBlock, inputDataType);
    }

    protected static class TransportRequest
    extends AbstractLookupService.TransportRequest {
        private final String matchField;

        TransportRequest(String sessionId, ShardId shardId, DataType inputDataType, Page inputPage, Page toRelease, List<NamedExpression> extractFields, String matchField, Source source) {
            super(sessionId, shardId, inputDataType, inputPage, toRelease, extractFields, source);
            this.matchField = matchField;
        }

        static TransportRequest readFrom(StreamInput in, BlockFactory blockFactory) throws IOException {
            Page inputPage;
            TaskId parentTaskId = TaskId.readFromStream((StreamInput)in);
            String sessionId = in.readString();
            ShardId shardId = new ShardId(in);
            DataType inputDataType = DataType.fromTypeName((String)in.readString());
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                inputPage = new Page((StreamInput)bsi);
            }
            PlanStreamInput planIn = new PlanStreamInput(in, in.namedWriteableRegistry(), null);
            List extractFields = planIn.readNamedWriteableCollectionAsList(NamedExpression.class);
            String matchField = in.readString();
            Source source = Source.EMPTY;
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_RUNTIME_WARNINGS)) {
                source = Source.readFrom((StreamInput)planIn);
            }
            TransportRequest result = new TransportRequest(sessionId, shardId, inputDataType, inputPage, inputPage, extractFields, matchField, source);
            result.setParentTask(parentTaskId);
            return result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeWriteable((Writeable)this.shardId);
            out.writeString(this.inputDataType.typeName());
            out.writeWriteable((Writeable)this.inputPage);
            PlanStreamOutput planOut = new PlanStreamOutput(out, null);
            planOut.writeNamedWriteableCollection(this.extractFields);
            out.writeString(this.matchField);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_RUNTIME_WARNINGS)) {
                this.source.writeTo((StreamOutput)planOut);
            }
        }

        @Override
        protected String extraDescription() {
            return " ,match_field=" + this.matchField;
        }
    }

    public static class Request
    extends AbstractLookupService.Request {
        private final String matchField;

        Request(String sessionId, String index, DataType inputDataType, String matchField, Page inputPage, List<NamedExpression> extractFields, Source source) {
            super(sessionId, index, inputDataType, inputPage, extractFields, source);
            this.matchField = matchField;
        }
    }
}

