/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.Iterator;
import java.util.List;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.core.esql.action.EsqlResponse;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;

public class EsqlResponseImpl
implements EsqlResponse {
    private final EsqlQueryResponse queryResponse;
    private boolean closed;

    EsqlResponseImpl(EsqlQueryResponse queryResponse) {
        this.queryResponse = queryResponse;
    }

    public List<? extends ColumnInfo> columns() {
        return this.queryResponse.columns();
    }

    public Iterable<Iterable<Object>> rows() {
        this.ensureOpen();
        return () -> {
            this.ensureOpen();
            return new DelegatingIterator<Iterable<Object>>(this.queryResponse.rows().iterator());
        };
    }

    public Iterable<Object> column(int columnIndex) {
        this.ensureOpen();
        return () -> {
            this.ensureOpen();
            return new DelegatingIterator<Object>(this.queryResponse.column(columnIndex));
        };
    }

    public void close() {
        this.setClosedState();
    }

    public void setClosedState() {
        this.closed = true;
    }

    private void ensureOpen() {
        if (this.closed || !this.queryResponse.hasReferences()) {
            throw new IllegalStateException("closed");
        }
    }

    public String toString() {
        return "EsqlResponse[response=" + String.valueOf((Object)this.queryResponse) + "]";
    }

    final class DelegatingIterator<T>
    implements Iterator<T> {
        final Iterator<T> delegate;

        DelegatingIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            EsqlResponseImpl.this.ensureOpen();
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            EsqlResponseImpl.this.ensureOpen();
            return this.delegate.next();
        }
    }
}

