/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.eql.execution.assembler.ExecutionManager;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class SampleExec
extends PhysicalPlan {
    private final List<List<Attribute>> keys;
    private final Limit limit;

    public SampleExec(Source source, List<PhysicalPlan> children, List<List<Attribute>> keys) {
        this(source, children, keys, null);
    }

    public SampleExec(Source source, List<PhysicalPlan> children, List<List<Attribute>> keys, Limit limit) {
        super(source, children);
        this.keys = keys;
        this.limit = limit;
    }

    protected NodeInfo<SampleExec> info() {
        return NodeInfo.create((Node)this, SampleExec::new, (Object)this.children(), this.keys, (Object)this.limit);
    }

    public PhysicalPlan replaceChildren(List<PhysicalPlan> newChildren) {
        return new SampleExec(this.source(), newChildren, this.keys, this.limit);
    }

    @Override
    public List<Attribute> output() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        for (List<Attribute> ne : this.keys) {
            attrs.addAll(Expressions.asAttributes(ne));
        }
        return attrs;
    }

    public List<List<Attribute>> keys() {
        return this.keys;
    }

    @Override
    public void execute(EqlSession session, ActionListener<Payload> listener) {
        new ExecutionManager(session).assemble(this.keys(), this.children(), this.limit).execute(listener);
    }

    public PhysicalPlan with(Limit limit) {
        return new SampleExec(this.source(), this.children(), this.keys, limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keys, this.children(), this.limit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SampleExec other = (SampleExec)obj;
        return Objects.equals(this.children(), other.children()) && Objects.equals(this.keys, other.keys) && Objects.equals(this.limit, other.limit);
    }
}

