/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;

public class TransportMountSearchableSnapshotAction
extends TransportMasterNodeAction<MountSearchableSnapshotRequest, RestoreSnapshotResponse> {
    private static final Collection<Setting<String>> DATA_TIER_ALLOCATION_SETTINGS = List.of(DataTier.TIER_PREFERENCE_SETTING);
    private final Client client;
    private final RepositoriesService repositoriesService;
    private final XPackLicenseState licenseState;
    private final SystemIndices systemIndices;

    @Inject
    public TransportMountSearchableSnapshotAction(TransportService transportService, ClusterService clusterService, Client client, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState, SystemIndices systemIndices) {
        super("cluster:admin/snapshot/mount", transportService, clusterService, threadPool, actionFilters, MountSearchableSnapshotRequest::new, indexNameExpressionResolver, RestoreSnapshotResponse::new, (Executor)threadPool.executor("snapshot_meta"));
        this.client = client;
        this.repositoriesService = repositoriesService;
        this.licenseState = Objects.requireNonNull(licenseState);
        this.systemIndices = Objects.requireNonNull(systemIndices);
    }

    protected ClusterBlockException checkBlock(MountSearchableSnapshotRequest request, ClusterState state) {
        return null;
    }

    private static Settings buildIndexSettings(String repoUuid, String repoName, SnapshotId snapshotId, IndexId indexId, MountSearchableSnapshotRequest.Storage storage) {
        Settings.Builder settings = Settings.builder();
        if (!repoUuid.equals("_na_")) {
            settings.put(SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.getKey(), repoUuid);
        }
        settings.put(SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.getKey(), repoName).put(SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.getKey(), snapshotId.getName()).put(SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.getKey(), snapshotId.getUUID()).put(SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.getKey(), indexId.getName()).put(SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.getKey(), indexId.getId()).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), "snapshot").put(IndexMetadata.SETTING_BLOCKS_WRITE, true).put(ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.getKey(), "searchable_snapshot_allocator").put(IndexModule.INDEX_RECOVERY_TYPE_SETTING.getKey(), "snapshot_prewarm");
        if (storage == MountSearchableSnapshotRequest.Storage.SHARED_CACHE) {
            settings.put(SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.getKey(), true).put(DiskThresholdDecider.SETTING_IGNORE_DISK_WATERMARKS.getKey(), true);
            settings.put(ShardLimitValidator.INDEX_SETTING_SHARD_LIMIT_GROUP.getKey(), "frozen");
        }
        return settings.build();
    }

    protected void masterOperation(Task task, MountSearchableSnapshotRequest request, ClusterState state, ActionListener<RestoreSnapshotResponse> listener) {
        SearchableSnapshots.ensureValidLicense(this.licenseState);
        String mountedIndexName = request.mountedIndexName();
        if (this.systemIndices.isSystemIndex(mountedIndexName)) {
            throw new ElasticsearchException("system index [{}] cannot be mounted as searchable snapshots", new Object[]{mountedIndexName});
        }
        String repoName = request.repositoryName();
        String snapName = request.snapshotName();
        String indexName = request.snapshotIndexName();
        Repository repository = this.repositoriesService.repository(repoName);
        SearchableSnapshots.getSearchableRepository(repository);
        ListenableFuture repositoryDataListener = new ListenableFuture();
        repository.getRepositoryData((Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, (ActionListener)repositoryDataListener);
        repositoryDataListener.addListener(listener.delegateFailureAndWrap((delegate, repoData) -> {
            Map indexIds = repoData.getIndices();
            if (!indexIds.containsKey(indexName)) {
                throw new IndexNotFoundException("index [" + indexName + "] not found in repository [" + repoName + "]");
            }
            IndexId indexId = (IndexId)indexIds.get(indexName);
            Optional<SnapshotId> matchingSnapshotId = repoData.getSnapshotIds().stream().filter(s -> snapName.equals(s.getName())).findFirst();
            if (matchingSnapshotId.isEmpty()) {
                throw new ElasticsearchException("snapshot [" + snapName + "] not found in repository [" + repoName + "]", new Object[0]);
            }
            SnapshotId snapshotId = matchingSnapshotId.get();
            IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repoData, snapshotId, indexId);
            if (indexMetadata.isSearchableSnapshot()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] in snapshot [%s/%s:%s] is a snapshot of a searchable snapshot index backed by index [%s] in snapshot [%s/%s:%s] and cannot be mounted; did you mean to restore it instead?", indexName, repoName, repository.getMetadata().uuid(), snapName, SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexMetadata.getSettings()), SearchableSnapshots.SNAPSHOT_REPOSITORY_NAME_SETTING.get(indexMetadata.getSettings()), SearchableSnapshots.SNAPSHOT_REPOSITORY_UUID_SETTING.get(indexMetadata.getSettings()), SearchableSnapshots.SNAPSHOT_SNAPSHOT_NAME_SETTING.get(indexMetadata.getSettings())));
            }
            LinkedHashSet<String> ignoreIndexSettings = new LinkedHashSet<String>(Arrays.asList(request.ignoreIndexSettings()));
            ignoreIndexSettings.add("index.data_path");
            for (Object indexSettingKey : indexMetadata.getSettings().keySet()) {
                if (!((String)indexSettingKey).startsWith("index.routing.allocation.require") && !((String)indexSettingKey).startsWith("index.routing.allocation.include") && !((String)indexSettingKey).startsWith("index.routing.allocation.exclude")) continue;
                ignoreIndexSettings.add((String)indexSettingKey);
            }
            Settings indexSettings = Settings.builder().put("index.number_of_replicas", 0).put("index.auto_expand_replicas", false).put(IndexSettings.INDEX_CHECK_ON_STARTUP.getKey(), false).put("index.routing.allocation.include._tier_preference", request.storage().defaultDataTiersPreference()).put(request.indexSettings()).put(TransportMountSearchableSnapshotAction.buildIndexSettings(repoData.getUuid(), request.repositoryName(), snapshotId, indexId, request.storage())).build();
            for (Setting setting : DATA_TIER_ALLOCATION_SETTINGS) {
                setting.get(indexSettings);
            }
            RestoreSnapshotRequest restoreSnapshotRequest = new RestoreSnapshotRequest(request.masterNodeTimeout(), repoName, snapName).indices(new String[]{indexName}).renamePattern(".+").renameReplacement(mountedIndexName).indexSettings(indexSettings).ignoreIndexSettings(ignoreIndexSettings.toArray(new String[0])).includeGlobalState(false).includeAliases(false).waitForCompletion(request.waitForCompletion()).snapshotUuid(snapshotId.getUUID()).quiet(true);
            restoreSnapshotRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
            this.client.admin().cluster().restoreSnapshot(restoreSnapshotRequest, delegate);
        }), (Executor)this.threadPool.executor("snapshot_meta"), null);
    }
}

