/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResult
extends LDAPResult {
    private static final long serialVersionUID = 1938208530894131198L;
    private int numEntries;
    private int numReferences;
    @Nullable
    private List<SearchResultEntry> searchEntries;
    @Nullable
    private List<SearchResultReference> searchReferences;

    public SearchResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, int numEntries, int numReferences, @Nullable Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
        this.numEntries = numEntries;
        this.numReferences = numReferences;
        this.searchEntries = null;
        this.searchReferences = null;
    }

    public SearchResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable List<SearchResultEntry> searchEntries, @Nullable List<SearchResultReference> searchReferences, int numEntries, int numReferences, @Nullable Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
        this.numEntries = numEntries;
        this.numReferences = numReferences;
        this.searchEntries = searchEntries;
        this.searchReferences = searchReferences;
    }

    public SearchResult(@NotNull LDAPResult ldapResult) {
        super(ldapResult);
        if (ldapResult instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)ldapResult;
            this.numEntries = searchResult.numEntries;
            this.numReferences = searchResult.numReferences;
            this.searchEntries = searchResult.searchEntries;
            this.searchReferences = searchResult.searchReferences;
        } else {
            this.numEntries = -1;
            this.numReferences = -1;
            this.searchEntries = null;
            this.searchReferences = null;
        }
    }

    public SearchResult(@NotNull LDAPException ldapException) {
        this(ldapException.toLDAPResult());
    }

    @NotNull
    static SearchResult readSearchResultFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader) throws LDAPException {
        LDAPResult r = LDAPResult.readLDAPResultFrom(messageID, messageSequence, reader);
        return new SearchResult(messageID, r.getResultCode(), r.getDiagnosticMessage(), r.getMatchedDN(), r.getReferralURLs(), -1, -1, r.getResponseControls());
    }

    public int getEntryCount() {
        return this.numEntries;
    }

    public int getReferenceCount() {
        return this.numReferences;
    }

    @Nullable
    public List<SearchResultEntry> getSearchEntries() {
        if (this.searchEntries == null) {
            return null;
        }
        return Collections.unmodifiableList(this.searchEntries);
    }

    @Nullable
    public SearchResultEntry getSearchEntry(@NotNull String dn) throws LDAPException {
        if (this.searchEntries == null) {
            return null;
        }
        DN parsedDN = new DN(dn);
        for (SearchResultEntry e : this.searchEntries) {
            if (!parsedDN.equals(e.getParsedDN())) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public List<SearchResultReference> getSearchReferences() {
        if (this.searchReferences == null) {
            return null;
        }
        return Collections.unmodifiableList(this.searchReferences);
    }

    void setCounts(int numEntries, @Nullable List<SearchResultEntry> searchEntries, int numReferences, @Nullable List<SearchResultReference> searchReferences) {
        this.numEntries = numEntries;
        this.numReferences = numReferences;
        this.searchEntries = searchEntries == null ? null : Collections.unmodifiableList(searchEntries);
        this.searchReferences = searchReferences == null ? null : Collections.unmodifiableList(searchReferences);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("SearchResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if (this.numEntries >= 0) {
            buffer.append(", entriesReturned=");
            buffer.append(this.numEntries);
        }
        if (this.numReferences >= 0) {
            buffer.append(", referencesReturned=");
            buffer.append(this.numReferences);
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

