/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerChain;
import org.opensaml.messaging.handler.MessageHandlerException;

public class BasicMessageHandlerChain
extends AbstractMessageHandler
implements MessageHandlerChain {
    @NonnullAfterInit
    @NonnullElements
    private List<MessageHandler> members;

    @NonnullAfterInit
    @NonnullElements
    public List<MessageHandler> getHandlers() {
        return this.members;
    }

    public void setHandlers(@Nullable @NonnullElements List<MessageHandler> handlers) {
        this.members = handlers != null ? List.copyOf(handlers) : Collections.emptyList();
    }

    public void doInvoke(@Nonnull MessageContext msgContext) throws MessageHandlerException {
        if (this.members != null) {
            for (MessageHandler handler : this.members) {
                handler.invoke(msgContext);
            }
        }
    }
}

