/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.attachment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.ReflectPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.PropertyPermission;
import java.util.Set;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.epub.EpubParser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.iwork.IWorkPackageParser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OldExcelParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.microsoft.rtf.RTFParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.DcXMLParser;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.jdk.JarHell;

final class TikaImpl {
    private static final Set<MediaType> EXCLUDES = new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.ms-visio.drawing"), MediaType.application((String)"vnd.ms-visio.drawing.macroenabled.12"), MediaType.application((String)"vnd.ms-visio.stencil"), MediaType.application((String)"vnd.ms-visio.stencil.macroenabled.12"), MediaType.application((String)"vnd.ms-visio.template"), MediaType.application((String)"vnd.ms-visio.template.macroenabled.12"), MediaType.application((String)"vnd.ms-visio.drawing")));
    private static final Parser[] PARSERS = new Parser[]{new HtmlParser(), new RTFParser(), new PDFParser(), new TXTParser(), new OfficeParser(), new OldExcelParser(), ParserDecorator.withoutTypes((Parser)new OOXMLParser(), EXCLUDES), new OpenDocumentParser(), new IWorkPackageParser(), new DcXMLParser(), new EpubParser()};
    private static final AutoDetectParser PARSER_INSTANCE = new AutoDetectParser(PARSERS);
    private static final Tika TIKA_INSTANCE = new Tika(PARSER_INSTANCE.getDetector(), (Parser)PARSER_INSTANCE);
    private static final AccessControlContext RESTRICTED_CONTEXT = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, TikaImpl.getRestrictedPermissions())});

    TikaImpl() {
    }

    static String parse(byte[] content, Metadata metadata, int limit) throws TikaException, IOException {
        SpecialPermission.check();
        try {
            return AccessController.doPrivileged(() -> TIKA_INSTANCE.parseToString((InputStream)new ByteArrayInputStream(content), metadata, limit), RESTRICTED_CONTEXT);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TikaException) {
                TikaException tikaException = (TikaException)cause;
                throw tikaException;
            }
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw new AssertionError((Object)cause);
        }
        catch (LinkageError e) {
            if (e.getMessage().contains("bouncycastle")) {
                throw new RuntimeException("document is encrypted", e);
            }
            throw new RuntimeException(e);
        }
    }

    @SuppressForbidden(reason="adds access to tmp directory")
    static PermissionCollection getRestrictedPermissions() {
        Permissions perms = new Permissions();
        perms.add(new PropertyPermission("*", "read"));
        perms.add(new RuntimePermission("getenv.TIKA_CONFIG"));
        try {
            TikaImpl.addReadPermissions(perms, JarHell.parseClassPath());
            ClassLoader classLoader = TikaImpl.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                Object[] urls = urlClassLoader.getURLs();
                LinkedHashSet<URL> set = new LinkedHashSet<URL>(Arrays.asList(urls));
                if (set.size() != urls.length) {
                    throw new AssertionError((Object)("duplicate jars: " + Arrays.toString(urls)));
                }
                TikaImpl.addReadPermissions(perms, set);
            }
            FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"java.io.tmpdir", (Path)PathUtils.get((String)System.getProperty("java.io.tmpdir"), (String[])new String[0]), (String)"read,readlink,write,delete", (boolean)false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        perms.add(new SecurityPermission("putProviderProperty.BC"));
        perms.add(new SecurityPermission("insertProvider"));
        perms.add(new ReflectPermission("suppressAccessChecks"));
        perms.add(new RuntimePermission("accessClassInPackage.sun.java2d.cmm.kcms"));
        perms.add(new RuntimePermission("getClassLoader"));
        perms.setReadOnly();
        return perms;
    }

    @SuppressForbidden(reason="adds access to jar resources")
    static void addReadPermissions(Permissions perms, Set<URL> resources) throws IOException {
        try {
            for (URL url : resources) {
                Path path = PathUtils.get((URI)url.toURI());
                if (Files.isDirectory(path, new LinkOption[0])) {
                    FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"class.path", (Path)path, (String)"read,readlink", (boolean)false);
                    continue;
                }
                FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)path, (String)"read,readlink");
            }
        }
        catch (URISyntaxException bogus) {
            throw new RuntimeException(bogus);
        }
    }
}

