/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.rerank;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googlevertexai.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleDiscoveryEngineRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankTaskSettings;

public class GoogleVertexAiRerankModel
extends GoogleVertexAiModel {
    public GoogleVertexAiRerankModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GoogleVertexAiRerankServiceSettings.fromMap(serviceSettings, context), GoogleVertexAiRerankTaskSettings.fromMap(taskSettings), GoogleVertexAiSecretSettings.fromMap(secrets));
    }

    public GoogleVertexAiRerankModel(GoogleVertexAiRerankModel model, GoogleVertexAiRerankServiceSettings serviceSettings) {
        super((GoogleVertexAiModel)model, serviceSettings);
    }

    GoogleVertexAiRerankModel(String inferenceEntityId, TaskType taskType, String service, GoogleVertexAiRerankServiceSettings serviceSettings, GoogleVertexAiRerankTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = GoogleVertexAiRerankModel.buildUri(serviceSettings.projectId());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected GoogleVertexAiRerankModel(String inferenceEntityId, TaskType taskType, String service, String uri, GoogleVertexAiRerankServiceSettings serviceSettings, GoogleVertexAiRerankTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public GoogleVertexAiRerankServiceSettings getServiceSettings() {
        return (GoogleVertexAiRerankServiceSettings)super.getServiceSettings();
    }

    public GoogleVertexAiRerankTaskSettings getTaskSettings() {
        return (GoogleVertexAiRerankTaskSettings)super.getTaskSettings();
    }

    public GoogleVertexAiSecretSettings getSecretSettings() {
        return (GoogleVertexAiSecretSettings)super.getSecretSettings();
    }

    @Override
    public GoogleDiscoveryEngineRateLimitServiceSettings rateLimitServiceSettings() {
        return (GoogleDiscoveryEngineRateLimitServiceSettings)super.rateLimitServiceSettings();
    }

    @Override
    public ExecutableAction accept(GoogleVertexAiActionVisitor visitor, Map<String, Object> taskSettings, InputType inputType) {
        return visitor.create(this, taskSettings);
    }

    public static URI buildUri(String projectId) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("discoveryengine.googleapis.com").setPathSegments(new String[]{"v1", "projects", projectId, "locations", "global", "rankingConfigs", Strings.format((String)"%s:%s", (Object[])new Object[]{"default_ranking_config", "rank"})}).build();
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("top_n", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TOGGLE).setLabel("Top N").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies the number of the top n documents, which should be returned.").setType(SettingsConfigurationFieldType.BOOLEAN).setValue((Object)false).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

