/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class GoogleVertexAiSecretSettings
implements SecretSettings {
    public static final String NAME = "google_vertex_ai_secret_settings";
    public static final String SERVICE_ACCOUNT_JSON = "service_account_json";
    final SecureString serviceAccountJson;

    public static GoogleVertexAiSecretSettings fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        SecureString secureServiceAccountJson = ServiceUtils.extractRequiredSecureString(map, SERVICE_ACCOUNT_JSON, "secret_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiSecretSettings(secureServiceAccountJson);
    }

    public GoogleVertexAiSecretSettings(SecureString serviceAccountJson) {
        this.serviceAccountJson = Objects.requireNonNull(serviceAccountJson);
    }

    public GoogleVertexAiSecretSettings(StreamInput in) throws IOException {
        this(in.readSecureString());
    }

    public SecureString serviceAccountJson() {
        return this.serviceAccountJson;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SERVICE_ACCOUNT_JSON, this.serviceAccountJson.toString());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeSecureString(this.serviceAccountJson);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleVertexAiSecretSettings that = (GoogleVertexAiSecretSettings)object;
        return Objects.equals(this.serviceAccountJson, that.serviceAccountJson);
    }

    public int hashCode() {
        return Objects.hash(this.serviceAccountJson);
    }

    public SecretSettings newSecretSettings(Map<String, Object> newSecrets) {
        return GoogleVertexAiSecretSettings.fromMap(new HashMap<String, Object>(newSecrets));
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put(GoogleVertexAiSecretSettings.SERVICE_ACCOUNT_JSON, new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Credentials JSON").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(true)).setTooltip("API Key for the provider you're connecting to.").setType(SettingsConfigurationFieldType.STRING).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

