/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.anthropic.AnthropicActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicModel;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class AnthropicChatCompletionModel
extends AnthropicModel {
    public static AnthropicChatCompletionModel of(AnthropicChatCompletionModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        AnthropicChatCompletionRequestTaskSettings requestTaskSettings = AnthropicChatCompletionRequestTaskSettings.fromMap(taskSettings);
        return new AnthropicChatCompletionModel(model, AnthropicChatCompletionTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public AnthropicChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, AnthropicChatCompletionServiceSettings.fromMap(serviceSettings, context), AnthropicChatCompletionTaskSettings.fromMap(taskSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    AnthropicChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, AnthropicChatCompletionServiceSettings serviceSettings, AnthropicChatCompletionTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)AnthropicChatCompletionModel::buildDefaultUri), secrets);
    }

    AnthropicChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, String url, AnthropicChatCompletionServiceSettings serviceSettings, AnthropicChatCompletionTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)() -> ServiceUtils.createUri(url)), secrets);
    }

    private AnthropicChatCompletionModel(AnthropicChatCompletionModel originalModel, AnthropicChatCompletionTaskSettings taskSettings) {
        super((AnthropicModel)originalModel, taskSettings);
    }

    public AnthropicChatCompletionServiceSettings getServiceSettings() {
        return (AnthropicChatCompletionServiceSettings)super.getServiceSettings();
    }

    public AnthropicChatCompletionTaskSettings getTaskSettings() {
        return (AnthropicChatCompletionTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(AnthropicActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    private static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.anthropic.com").setPathSegments(new String[]{"v1", "messages"}).build();
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("max_tokens", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Max Tokens").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The maximum number of tokens to generate before stopping.").setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.put("temperature", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Temperature").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("The amount of randomness injected into the response.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("top_k", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Top K").setOrder(Integer.valueOf(3)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies to only sample from the top K options for each subsequent token.").setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.put("top_p", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Top P").setOrder(Integer.valueOf(4)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies to use Anthropic\u2019s nucleus sampling.").setType(SettingsConfigurationFieldType.INTEGER).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

