/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.completion;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.amazonbedrock.AmazonBedrockActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;

public class AmazonBedrockChatCompletionModel
extends AmazonBedrockModel {
    public static AmazonBedrockChatCompletionModel of(AmazonBedrockChatCompletionModel completionModel, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return completionModel;
        }
        AmazonBedrockChatCompletionRequestTaskSettings requestTaskSettings = AmazonBedrockChatCompletionRequestTaskSettings.fromMap(taskSettings);
        AmazonBedrockChatCompletionTaskSettings taskSettingsToUse = AmazonBedrockChatCompletionTaskSettings.of(completionModel.getTaskSettings(), requestTaskSettings);
        return new AmazonBedrockChatCompletionModel((Model)completionModel, taskSettingsToUse);
    }

    public AmazonBedrockChatCompletionModel(String inferenceEntityId, TaskType taskType, String name, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secretSettings, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, name, AmazonBedrockChatCompletionServiceSettings.fromMap(serviceSettings, context), AmazonBedrockChatCompletionTaskSettings.fromMap(taskSettings), AmazonBedrockSecretSettings.fromMap(secretSettings));
    }

    public AmazonBedrockChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, AmazonBedrockChatCompletionServiceSettings serviceSettings, AmazonBedrockChatCompletionTaskSettings taskSettings, AmazonBedrockSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets));
    }

    public AmazonBedrockChatCompletionModel(Model model, TaskSettings taskSettings) {
        super(model, taskSettings);
    }

    @Override
    public ExecutableAction accept(AmazonBedrockActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    @Override
    public AmazonBedrockChatCompletionServiceSettings getServiceSettings() {
        return (AmazonBedrockChatCompletionServiceSettings)super.getServiceSettings();
    }

    public AmazonBedrockChatCompletionTaskSettings getTaskSettings() {
        return (AmazonBedrockChatCompletionTaskSettings)super.getTaskSettings();
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("max_new_tokens", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Max New Tokens").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Sets the maximum number for the output tokens to be generated.").setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.put("temperature", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Temperature").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("A number between 0.0 and 1.0 that controls the apparent creativity of the results.").setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.put("top_p", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Top P").setOrder(Integer.valueOf(3)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Alternative to temperature. A number in the range of 0.0 to 1.0, to eliminate low-probability tokens.").setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.put("top_k", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Top K").setOrder(Integer.valueOf(4)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Only available for anthropic, cohere, and mistral providers. Alternative to temperature.").setType(SettingsConfigurationFieldType.INTEGER).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

