/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.inference.configuration.SettingsConfigurationSelectOption;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.alibabacloudsearch.AlibabaCloudSearchActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class AlibabaCloudSearchSparseModel
extends AlibabaCloudSearchModel {
    public static AlibabaCloudSearchSparseModel of(AlibabaCloudSearchSparseModel model, Map<String, Object> taskSettings, InputType inputType) {
        AlibabaCloudSearchSparseTaskSettings requestTaskSettings = AlibabaCloudSearchSparseTaskSettings.fromMap(taskSettings);
        return new AlibabaCloudSearchSparseModel(model, AlibabaCloudSearchSparseTaskSettings.of(model.getTaskSettings(), requestTaskSettings, inputType));
    }

    public AlibabaCloudSearchSparseModel(String modelId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(modelId, taskType, service, AlibabaCloudSearchSparseServiceSettings.fromMap(serviceSettings, context), AlibabaCloudSearchSparseTaskSettings.fromMap(taskSettings), chunkingSettings, DefaultSecretSettings.fromMap(secrets));
    }

    AlibabaCloudSearchSparseModel(String modelId, TaskType taskType, String service, AlibabaCloudSearchSparseServiceSettings serviceSettings, AlibabaCloudSearchSparseTaskSettings taskSettings, ChunkingSettings chunkingSettings, @Nullable DefaultSecretSettings secretSettings) {
        super(new ModelConfigurations(modelId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings, chunkingSettings), new ModelSecrets((SecretSettings)secretSettings), serviceSettings.getCommonSettings());
    }

    private AlibabaCloudSearchSparseModel(AlibabaCloudSearchSparseModel model, AlibabaCloudSearchSparseTaskSettings taskSettings) {
        super((AlibabaCloudSearchModel)model, taskSettings);
    }

    public AlibabaCloudSearchSparseModel(AlibabaCloudSearchSparseModel model, AlibabaCloudSearchSparseServiceSettings serviceSettings) {
        super((AlibabaCloudSearchModel)model, serviceSettings);
    }

    public AlibabaCloudSearchSparseServiceSettings getServiceSettings() {
        return (AlibabaCloudSearchSparseServiceSettings)super.getServiceSettings();
    }

    public AlibabaCloudSearchSparseTaskSettings getTaskSettings() {
        return (AlibabaCloudSearchSparseTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(AlibabaCloudSearchActionVisitor visitor, Map<String, Object> taskSettings, InputType inputType) {
        return visitor.create(this, taskSettings, inputType);
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("input_type", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.DROPDOWN).setLabel("Input Type").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies the type of input passed to the model.").setType(SettingsConfigurationFieldType.STRING).setOptions(Stream.of("ingest", "search").map(v -> new SettingsConfigurationSelectOption.Builder().setLabelAndValue(v).build()).toList()).setValue((Object)"").build());
            configurationMap.put("return_token", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TOGGLE).setLabel("Return Token").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("If `true`, the token name will be returned in the response. Defaults to `false` which means only the token ID will be returned in the response.").setType(SettingsConfigurationFieldType.BOOLEAN).setValue((Object)true).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

