/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.googleaistudio;

import java.util.Map;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorMessage;

public class GoogleAiStudioErrorResponseEntity
implements ErrorMessage {
    private final String errorMessage;

    private GoogleAiStudioErrorResponseEntity(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GoogleAiStudioErrorResponseEntity fromResponse(HttpResult response) {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            Map responseMap = jsonParser.map();
            Map error = (Map)responseMap.get("error");
            if (error == null) return null;
            String message = (String)error.get("message");
            if (message == null) return null;
            GoogleAiStudioErrorResponseEntity googleAiStudioErrorResponseEntity = new GoogleAiStudioErrorResponseEntity(message);
            return googleAiStudioErrorResponseEntity;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

