/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response;

import java.util.Map;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorMessage;

public class ErrorMessageResponseEntity
implements ErrorMessage {
    protected String errorMessage;

    public ErrorMessageResponseEntity(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ErrorMessage fromResponse(HttpResult response) {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            Map responseMap = jsonParser.map();
            Map error = (Map)responseMap.get("error");
            if (error == null) return null;
            String message = (String)error.get("message");
            if (message == null) return null;
            ErrorMessageResponseEntity errorMessageResponseEntity = new ErrorMessageResponseEntity(message);
            return errorMessageResponseEntity;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

